/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.nacos;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPrePropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaPropertiesProcessor;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.JaClassUtil;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConstants;
import java.util.Properties;
import java.util.function.BiConsumer;

public class JaNacosPrePropertyHandler
implements JaPrePropertyHandler {
    public void addAndCover() {
        try {
            System.setProperty("project.name", JaEnvProperty.getApplicationName());
            JaNacosPrePropertyHandler.loadPropertiesByEnv();
            JaNacosPrePropertyHandler.loadPropertiesByLocal(new String[0]);
            this.wrapDiscovery();
        }
        catch (Throwable e) {
            JaLog.error((String)"nacos config init error", (Object[])new Object[]{e});
        }
    }

    public int order() {
        return -100;
    }

    public static void loadPropertiesByLocal(String ... env) {
        if (JaStringUtil.isEmpty((String)JaProperty.get((String)"ja.nacos.serverAddr"))) {
            String path = String.format("nacos/%s.properties", JaCollectionUtil.isEmpty((Object[])env) ? JaEnvProperty.getEnv() : env[0]);
            Properties properties = JaPropertiesProcessor.readByResources((String)path);
            if (null != properties) {
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o, o2) -> JaProperty.getPropertyMap().put(o.toString(), o2)));
            } else {
                JaLog.warn((String)"nacos loadPropertiesByLocal empty", (Object[])new Object[0]);
            }
        }
    }

    public static void loadPropertiesByEnv() {
        if (JaStringUtil.isSafeNotEmpty((String)System.getenv("ja.nacos.serverAddr"))) {
            for (String key : JaNacosConstants.KeyArray) {
                JaProperty.getPropertyMap().put(key, System.getenv(key));
            }
        }
    }

    private void wrapDiscovery() {
        if (JaClassUtil.hashClass((String)"com.alibaba.nacos.api.naming.NamingService") && JaStringUtil.isSafeNotEmpty((String)JaProperty.get((String)"ja.nacos.serverAddr"))) {
            this.addAndCover("spring.cloud.nacos.server-addr", JaProperty.get((String)"ja.nacos.serverAddr"));
            this.addAndCover("spring.cloud.nacos.username", JaProperty.get((String)"ja.nacos.username"));
            this.addAndCover("spring.cloud.nacos.password", JaProperty.get((String)"ja.nacos.password"));
        }
    }
}

