/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.nacos.config;

import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.JaNacosConfigServerEntity;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import java.util.Properties;

public class JaNacosConfigPropertiesProcessor {
    private static JaNacosConfigServerEntity entity;

    private JaNacosConfigPropertiesProcessor() {
    }

    public static JaNacosConfigServerEntity getEntity() {
        return entity;
    }

    public static String getNameSpaceApplication() {
        return DwProperty.get((String)"ja.nacos.namespace.application");
    }

    public static String getNameSpaceCommon() {
        return DwProperty.get((String)"ja.nacos.namespace.common");
    }

    public static boolean getEnabled() {
        return DwProperty.getBoolean((String)"ja.nacos.configEnabled", (Boolean)true);
    }

    public static Properties getServerAddrProperties(JaNacosConfigServerEntity entity) {
        Properties properties = new Properties();
        if (DwStringUtil.isEmpty((String)entity.getServerAddr())) {
            return null;
        }
        properties.put("serverAddr", entity.getServerAddr());
        if (DwStringUtil.isSafeNotEmpty((String)entity.getUsername())) {
            properties.put("username", entity.getUsername());
        }
        if (DwStringUtil.isSafeNotEmpty((String)entity.getPassword())) {
            properties.put("password", entity.getPassword());
        }
        return properties;
    }

    public static Properties getServerAddrProperties() {
        if (null != entity) {
            return JaNacosConfigPropertiesProcessor.getServerAddrProperties(entity);
        }
        entity = new JaNacosConfigServerEntity();
        entity.setServerAddr(DwProperty.get((String)"ja.nacos.serverAddr"));
        entity.setUsername(DwProperty.get((String)"ja.nacos.username"));
        entity.setPassword(DwProperty.get((String)"ja.nacos.password"));
        return JaNacosConfigPropertiesProcessor.getServerAddrProperties(entity);
    }
}

