package com.digiwin.dap.nest.infrastructure.middleware.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.digiwin.dap.nest.kernel.core.util.reflect.clazz.JaClassUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.JaSpringBeanUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.JaSpringCloudFix;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

import java.time.Duration;

public class JaNacosDiscoverySpringApplicationRunListener implements SpringApplicationRunListener, Ordered {

    public JaNacosDiscoverySpringApplicationRunListener(SpringApplication springApplication, String[] args) {
    }

    public void starting() {
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void started(ConfigurableApplicationContext context, Duration timeTaken) {
        if (!JaSpringCloudFix.isCloudContainer()) {
            if (JaClassUtil.hashClass("com.alibaba.nacos.api.naming.NamingService")) {
                JaNamingService.setNamingService(JaNamingService.getNamingServiceByNacosServiceManager());
                JaNacosDiscoveryPropertiesProcessor.setNacosDiscoveryProperties(JaSpringBeanUtil.getBean(NacosDiscoveryProperties.class));
                JaNamingService.registerInstancesByCurrentInstance();
//                JaNamingService.deregisterCurrentInstance();
            }
        }
    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }


    @Override
    public int getOrder() {
        return -5;
    }
}