package com.digiwin.dap.nest.infrastructure.middleware.nacos.config;

import com.alibaba.nacos.api.common.Constants;
import com.digiwin.dap.nest.kernel.core.config.JaCenterPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.JaEnvProperty;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.listenter.JaNacosConfigDefaultListener;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.JaNacosConfigEntity;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.JaNacosConstants;

import java.util.Map;

/**
 * 加载应用配置
 *
 * @author chenjian
 * @since 2024年06月14日 17:42:12
 */
public class JaNacosConfigPropertyHandler implements JaCenterPropertyHandler {

    @Override
    public void addAndCover() {
        try {
            wrapCommon();
            wrapApplication();
        } catch (Throwable e) {
            JaLog.error("JaNacosConfigPropertyHandler read error", e);
        }
    }

    private void wrapCommon() {
        Map<String, Object> nacosMap = JaNacosConfigService.readYaml(JaNacosConfigEntity.builder()
                .dataId("jugg-application.yml")
                .group(Constants.DEFAULT_GROUP)
                .namespace(JaNacosConfigPropertiesProcessor.getNameSpaceCommon())
                .listener(Boolean.TRUE.equals(DwProperty.getBoolean(JaNacosConstants.KeyUseListener, true)) ? JaNacosConfigDefaultListener.DefaultListener : null)
                .build());
        if (JaCollectionUtil.isNotEmpty(nacosMap)) {
            DwProperty.getPropertyMap().putAll(nacosMap);
        }
    }


    private void wrapApplication() {
        String version = JaEnvProperty.getVersion();
        if (DwStringUtil.isEmpty(version)) {
            version = Constants.DEFAULT_GROUP;
        }
        Map<String, Object> nacosMap = JaNacosConfigService.readYaml(JaNacosConfigEntity.builder()
                .dataId(JaEnvProperty.getApplicationName() + "-application.yml")
                .group(version)
                .namespace(JaNacosConfigPropertiesProcessor.getNameSpaceApplication())
                .listener(Boolean.TRUE.equals(DwProperty.getBoolean(JaNacosConstants.KeyUseListener, true)) ? JaNacosConfigDefaultListener.DefaultListener : null)
                .build());
        if (JaCollectionUtil.isNotEmpty(nacosMap)) {
            DwProperty.getPropertyMap().putAll(nacosMap);
        }
    }
}
