/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.nacos.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.listenter.JaNacosConfigListener;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.JaNacosConfigEntity;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.JaNacosConfigServerEntity;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.config.JaEnvProperty;
import com.digiwin.dap.nest.kernel.core.config.processor.JaYamlProcessor;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.util.DwShutdownHookUtil;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.JaThrowableUtil;
import com.digiwin.dap.nest.kernel.core.util.JaValidateUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.kernel.core.util.reflect.clazz.JaClassUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JaNacosConfigService {
    public static String read(JaNacosConfigEntity entity, Properties properties) {
        if (!JaNacosConfigPropertiesProcessor.getEnabled()) {
            return null;
        }
        String dataId = entity.getDataId();
        JaValidateUtil.notNull((String)dataId, () -> "read nacos dataId is null");
        String group = entity.getGroup();
        JaValidateUtil.notNull((String)group, () -> "read nacos group is null");
        String namespace = entity.getNamespace();
        JaValidateUtil.notNull((String)namespace, () -> "read nacos namespace is null");
        JaValidateUtil.notNull((Map)properties, () -> "read nacos properties is null");
        properties.put("namespace", namespace);
        ConfigService configService = NacosFactory.createConfigService((Properties)properties);
        String content = configService.getConfig(dataId, entity.getGroup(), entity.getTimeoutMs());
        if (null != entity.getListener()) {
            configService.addListener(dataId, entity.getGroup(), (Listener)entity.getListener());
            DwShutdownHookUtil.add((String)dataId, () -> JaThrowableUtil.tryCatchRun(() -> ((ConfigService)configService).shutDown()));
        } else {
            configService.shutDown();
        }
        JaLog.info((String)"{} {} nacos config : \n{}", (Object[])new Object[]{dataId, group, content});
        return content;
    }

    public static String read(JaNacosConfigEntity entity, JaNacosConfigServerEntity serverEntity) {
        return JaNacosConfigService.read(entity, JaNacosConfigPropertiesProcessor.getServerAddrProperties(serverEntity));
    }

    public static Map<String, Object> readYaml(JaNacosConfigEntity entity, Properties properties) {
        String content = JaNacosConfigService.read(entity, properties);
        return DwStringUtil.isEmpty((String)content) ? new HashMap(0) : JaYamlProcessor.getFlattenedMap((String)content);
    }

    public static Map<String, Object> readYaml(JaNacosConfigEntity entity, JaNacosConfigServerEntity serverEntity) {
        return JaNacosConfigService.readYaml(entity, JaNacosConfigPropertiesProcessor.getServerAddrProperties(serverEntity));
    }

    public static Map<String, Object> readYaml(JaNacosConfigEntity entity) {
        Properties serverAddrProperties;
        try {
            serverAddrProperties = JaNacosConfigPropertiesProcessor.getServerAddrProperties();
            if (null == serverAddrProperties) {
                JaLog.warn((String)"{} nacos readYaml error, serverAddrProperties is null", (Object[])new Object[]{entity.getDataId()});
                return null;
            }
        }
        catch (NullPointerException e) {
            JaLog.warn((String)"{} nacos readYaml error, serverAddrProperties is null", (Object[])new Object[]{entity.getDataId()});
            return null;
        }
        return JaNacosConfigService.readYaml(entity, serverAddrProperties);
    }

    public static Map<String, Object> readYaml(String dataId, String namespace, JaNacosConfigListener listener) {
        return JaNacosConfigService.readYaml(JaNacosConfigEntity.builder().dataId(dataId).namespace(namespace).group(JaEnvProperty.getVersion()).listener(listener).build());
    }

    public static Map<String, Object> readYaml(String dataId, String namespace) {
        return JaNacosConfigService.readYaml(dataId, namespace, null);
    }

    public static void loadYaml(String dataId, String namespace) {
        Map<String, Object> nacosMap = JaNacosConfigService.readYaml(dataId, namespace, null);
        if (JaCollectionUtil.isNotEmpty(nacosMap)) {
            DwProperty.getPropertyMap().putAll(nacosMap);
        }
    }

    public static void main(String[] args) throws IOException {
        JaNacosConfigListener jaNacosConfigListener = new JaNacosConfigListener(){

            public void receiveConfigInfo(String configInfo) {
                System.out.println("configInfo : " + configInfo);
            }
        };
        Map<String, Object> read = JaNacosConfigService.readYaml(JaNacosConfigEntity.builder().namespace("8231cc09-273b-43db-8561-6a82f21f15e0").dataId("rabbitmq.yml").group("2.2.21").listener(jaNacosConfigListener).build(), ((JaNacosConfigServerEntity.JaNacosConfigServerEntityBuilder)((JaNacosConfigServerEntity.JaNacosConfigServerEntityBuilder)((JaNacosConfigServerEntity.JaNacosConfigServerEntityBuilder)JaNacosConfigServerEntity.builder().serverAddr("http://121.37.176.231:8848")).username("")).password("")).build());
        System.out.println(read);
        System.in.read();
    }

    static {
        if (JaClassUtil.hashClass((String)"ch.qos.logback.classic.LoggerContext") && JaLog.getUseLogback()) {
            System.setProperty("nacos.logging.config", "classpath:jugg-nacos-logback.xml");
        }
    }
}

