package com.digiwin.dap.nest.infrastructure.middleware.nacos.config.listenter;

import com.digiwin.dap.nest.kernel.core.config.processor.JaYamlProcessor;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;

import java.util.Map;

public interface JaNacosConfigYamlListener extends JaNacosConfigListener {
    void receiveConfigInfo(Map<String, Object> configInfo);

    default void receiveConfigInfo(final String configInfo) {
        if (DwStringUtil.isNotEmpty(configInfo)) {
            try {
                Map<String, Object> flattenedMap = JaYamlProcessor.getFlattenedMap(configInfo);
                if (JaCollectionUtil.isNotEmpty(flattenedMap)) {
                    receiveConfigInfo(flattenedMap);
                }
            } catch (Throwable e) {
                JaLog.error("nacos config listener receiveConfigInfo error:[{configInfo}]", e);
            }
        }
    }
}
