/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.nacos.config;

import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConfigServerEntity;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import java.util.Properties;

public class DwNacosConfigPropertiesProcessor {
    private static DwNacosConfigServerEntity entity;

    private DwNacosConfigPropertiesProcessor() {
    }

    public static DwNacosConfigServerEntity getEntity() {
        return entity;
    }

    public static String getNameSpaceApplication() {
        return DwProperty.get((String)"dw.nacos.namespace.application");
    }

    public static String getNameSpaceCommon() {
        return DwProperty.get((String)"dw.nacos.namespace.common");
    }

    public static boolean getEnabled() {
        return DwProperty.getBoolean((String)"dw.nacos.configEnabled", (Boolean)true);
    }

    public static Properties getServerAddrProperties(DwNacosConfigServerEntity entity) {
        Properties properties = new Properties();
        if (DwStringUtil.isEmpty((String)entity.getServerAddr())) {
            return null;
        }
        properties.put("serverAddr", entity.getServerAddr());
        if (DwStringUtil.isSafeNotEmpty((String)entity.getUsername())) {
            properties.put("username", entity.getUsername());
        }
        if (DwStringUtil.isSafeNotEmpty((String)entity.getPassword())) {
            properties.put("password", entity.getPassword());
        }
        return properties;
    }

    public static Properties getServerAddrProperties() {
        if (null != entity) {
            return DwNacosConfigPropertiesProcessor.getServerAddrProperties(entity);
        }
        entity = new DwNacosConfigServerEntity();
        entity.setServerAddr(DwProperty.get((String)"dw.nacos.serverAddr"));
        entity.setUsername(DwProperty.get((String)"dw.nacos.username"));
        entity.setPassword(DwProperty.get((String)"dw.nacos.password"));
        return DwNacosConfigPropertiesProcessor.getServerAddrProperties(entity);
    }
}

