package com.digiwin.dap.nest.infrastructure.middleware.nacos.config;

import com.alibaba.nacos.api.PropertyKeyConst;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConfigServerEntity;

import java.util.Properties;

import static com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConstants.KeyConfigEnabled;
import static com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConstants.KeyNameSpaceApplication;
import static com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConstants.KeyNameSpaceCommon;
import static com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConstants.KeyPassword;
import static com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConstants.KeyServerAddr;
import static com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConstants.KeyUsername;

/**
 * 配置中心处理器, 获取&缓存账号密码等相关配置
 *
 * @author chenjian
 * @since 2020年07月13日 12:05:52
 */
public class DwNacosConfigPropertiesProcessor {


    private DwNacosConfigPropertiesProcessor() {
    }

    /**
     * 地址 账号 密码全局缓存
     */
    private static DwNacosConfigServerEntity entity;

    public static DwNacosConfigServerEntity getEntity() {
        return entity;
    }

    /**
     * 应用 namespace
     */
    public static String getNameSpaceApplication() {
        return DwProperty.get(KeyNameSpaceApplication);
    }

    /**
     * 公共 namespace
     */
    public static String getNameSpaceCommon() {
        return DwProperty.get(KeyNameSpaceCommon);
    }

    /**
     * 读取nacos
     */
    public static boolean getEnabled() {
        return DwProperty.getBoolean(KeyConfigEnabled, true);
    }


    public static Properties getServerAddrProperties(DwNacosConfigServerEntity entity) {
        Properties properties = new Properties();
        if (DwStringUtil.isEmpty(entity.getServerAddr())) {
            return null;
        }
        properties.put(PropertyKeyConst.SERVER_ADDR, entity.getServerAddr());
        if (DwStringUtil.isSafeNotEmpty(entity.getUsername())) {
            properties.put(PropertyKeyConst.USERNAME, entity.getUsername());
        }
        if (DwStringUtil.isSafeNotEmpty(entity.getPassword())) {
            properties.put(PropertyKeyConst.PASSWORD, entity.getPassword());
        }
        return properties;
    }

    /**
     * 创建 ConfigService 所需 Properties
     */
    public static Properties getServerAddrProperties() {
        if (null != entity) {
            return getServerAddrProperties(entity);
        }
        entity = new DwNacosConfigServerEntity();
        entity.setServerAddr(DwProperty.get(KeyServerAddr));
        entity.setUsername(DwProperty.get(KeyUsername));
        entity.setPassword(DwProperty.get(KeyPassword));
        return getServerAddrProperties(entity);
    }
}
