/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.nacos;

import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConstants;
import com.digiwin.dap.nest.kernel.core.config.DwEnvProperty;
import com.digiwin.dap.nest.kernel.core.config.DwPrePropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.config.processor.JaPropertiesProcessor;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.kernel.core.util.reflect.clazz.JaClassUtil;
import java.util.Properties;
import java.util.function.BiConsumer;

public class DwNacosPrePropertyHandler
implements DwPrePropertyHandler {
    public void addAndCover() {
        try {
            System.setProperty("project.name", DwEnvProperty.getApplicationName());
            DwNacosPrePropertyHandler.loadPropertiesByEnv();
            DwNacosPrePropertyHandler.loadPropertiesByLocal(new String[0]);
            this.wrapDiscovery();
        }
        catch (Throwable e) {
            DwLog.error((String)"nacos config init error", (Object[])new Object[]{e});
        }
    }

    public int order() {
        return -100;
    }

    public static void loadPropertiesByLocal(String ... env) {
        if (DwStringUtil.isEmpty((String)DwProperty.get((String)"dw.nacos.serverAddr"))) {
            String path = String.format("nacos/%s.properties", JaCollectionUtil.isEmpty((Object[])env) ? DwEnvProperty.getEnv() : env[0]);
            Properties properties = JaPropertiesProcessor.readByResources((String)path);
            if (null != properties) {
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o, o2) -> DwProperty.getPropertyMap().put(o.toString(), o2)));
            } else {
                DwLog.warn((String)"nacos loadPropertiesByLocal empty", (Object[])new Object[0]);
            }
        }
    }

    public static void loadPropertiesByEnv() {
        if (DwStringUtil.isSafeNotEmpty((String)System.getenv("dw.nacos.serverAddr"))) {
            for (String key : DwNacosConstants.KeyArray) {
                DwProperty.getPropertyMap().put(key, System.getenv(key));
            }
        }
    }

    private void wrapDiscovery() {
        if (JaClassUtil.hashClass((String)"com.alibaba.nacos.api.naming.NamingService") && DwStringUtil.isSafeNotEmpty((String)DwProperty.get((String)"dw.nacos.serverAddr"))) {
            this.addAndCover("spring.cloud.nacos.server-addr", DwProperty.get((String)"dw.nacos.serverAddr"));
            this.addAndCover("spring.cloud.nacos.username", DwProperty.get((String)"dw.nacos.username"));
            this.addAndCover("spring.cloud.nacos.password", DwProperty.get((String)"dw.nacos.password"));
        }
    }
}

