package com.digiwin.dap.nest.infrastructure.middleware.nacos.config;

import com.alibaba.nacos.api.common.Constants;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.listenter.DwNacosConfigDefaultListener;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConfigEntity;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta.DwNacosConstants;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.config.DwCenterPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwEnvProperty;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.DwCollectionUtil;

import java.util.Map;

/**
 * 加载应用配置
 *
 * @author chenjian
 * @since 2024年06月14日 17:42:12
 */
public class DwNacosConfigCenterPropertyHandler implements DwCenterPropertyHandler {

    @Override
    public void addAndCover() {
        try {
            wrapCommon();
            wrapApplication();
        } catch (Throwable e) {
            DwLog.error("DwNacosConfigCenterPropertyHandler read error", e);
        }
    }

    private void wrapCommon() {
        Map<String, Object> nacosMap = DwNacosConfigService.readYaml(DwNacosConfigEntity.builder()
                .dataId("nest-application.yml")
                .group(Constants.DEFAULT_GROUP)
                .namespace(DwNacosConfigPropertiesProcessor.getNameSpaceCommon())
                .listener(Boolean.TRUE.equals(DwProperty.getBoolean(DwNacosConstants.KeyUseListener, true)) ? DwNacosConfigDefaultListener.DefaultListener : null)
                .build());
        if (DwCollectionUtil.isNotEmpty(nacosMap)) {
            DwProperty.getPropertyMap().putAll(nacosMap);
        }
    }


    private void wrapApplication() {
        String version = DwEnvProperty.getVersion();
        if (DwStringUtil.isEmpty(version)) {
            version = Constants.DEFAULT_GROUP;
        }
        Map<String, Object> nacosMap = DwNacosConfigService.readYaml(DwNacosConfigEntity.builder()
                .dataId(DwEnvProperty.getApplicationName() + "-application.yml")
                .group(version)
                .namespace(DwNacosConfigPropertiesProcessor.getNameSpaceApplication())
                .listener(Boolean.TRUE.equals(DwProperty.getBoolean(DwNacosConstants.KeyUseListener, true)) ? DwNacosConfigDefaultListener.DefaultListener : null)
                .build());
        if (DwCollectionUtil.isNotEmpty(nacosMap)) {
            DwProperty.getPropertyMap().putAll(nacosMap);
        }
    }
}
