package com.digiwin.dap.nest.infrastructure.middleware.nacos.config.listenter;

import com.digiwin.dap.nest.kernel.core.config.processor.DwYamlProcessor;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.DwCollectionUtil;

import java.util.Map;

public interface DwNacosConfigYamlListener extends DwNacosConfigListener {
    void receiveConfigInfo(Map<String, Object> configInfo);

    default void receiveConfigInfo(final String configInfo) {
        if (DwStringUtil.isNotEmpty(configInfo)) {
            try {
                Map<String, Object> flattenedMap = DwYamlProcessor.getFlattenedMap(configInfo);
                if (DwCollectionUtil.isNotEmpty(flattenedMap)) {
                    receiveConfigInfo(flattenedMap);
                }
            } catch (Throwable e) {
                DwLog.error("nacos config listener receiveConfigInfo error:[{configInfo}]", e);
            }
        }
    }
}
