package com.digiwin.dap.nest.infrastructure.middleware.nacos.config.meta;

import com.digiwin.dap.nest.kernel.core.config.DwConfig;

public class DwNacosConstants {
    private DwNacosConstants() {
    }

    /**
     * 配置 key
     */
    public static final String KeyServerAddr = DwConfig.KeyPrefix + "nacos.serverAddr";
    public static final String KeyUsername = DwConfig.KeyPrefix + "nacos.username";
    public static final String KeyPassword = DwConfig.KeyPrefix + "nacos.password";
    public static final String KeyNameSpaceApplication = DwConfig.KeyPrefix + "nacos.namespace.application";
    public static final String KeyNameSpaceCommon = DwConfig.KeyPrefix + "nacos.namespace.common";
    public static final String[] KeyArray = new String[]{KeyServerAddr, KeyUsername, KeyPassword, KeyNameSpaceApplication, KeyNameSpaceCommon};

    /**
     * 是否启用nacos配置中心
     */
    public static final String KeyConfigEnabled = DwConfig.KeyPrefix + "nacos.configEnabled";
    /**
     * 是否全局启用动态监听
     * 默认启用
     * 地端现状关闭
     */
    public static final String KeyUseListener = DwConfig.KeyPrefix + "nacos.useListener";

    /**
     * 集群注册自增Id
     */
    public static final String KeyMetaDataClusterId = DwConfig.KeyPrefix + "nacos.clusterId";

}
