package com.digiwin.dap.nest.infrastructure.middleware.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringBeanUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringCloudFix;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;

/**
 * 提供多服务名注册的能力
 *
 * @author chenjian
 * @since 2025年11月07日 20:09:36
 */
@Order(-100)
@Configuration
public class DwNacosDiscoveryInstanceRegisteredEvent implements ApplicationListener<InstanceRegisteredEvent<?>> {

    @Override
    public void onApplicationEvent(@NonNull InstanceRegisteredEvent event) {
        if (!DwSpringCloudFix.isCloudContainer()) {
            DwNamingService.setNamingService(DwNamingService.getNamingServiceByNacosServiceManager());
            DwNacosDiscoveryPropertiesProcessor.setNacosDiscoveryProperties(DwSpringBeanUtil.getBean(NacosDiscoveryProperties.class));
            // 多服务注册
            DwNamingService.registerInstancesByCurrentInstance();
//                JaNamingService.deregisterCurrentInstance();
        }
    }
}