package com.digiwin.dap.nest.infrastructure.middleware.rabbitmq.test.fanout;

import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.util.DwShutdownHookUtil;
import com.digiwin.dap.nest.infrastructure.middleware.rabbitmq.test.TestConnectionFactory;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import lombok.SneakyThrows;

import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class JaRabbitMQConsumerTestFanout {

    @SneakyThrows
    public static void consumer(String connectionName) {
        ConnectionFactory factory = TestConnectionFactory.get();
        Connection connection = factory.newConnection(connectionName);
        Channel channel = connection.createChannel();
        channel.exchangeDeclare(JaRabbitMQProducerTestFanout.ExchangeName, BuiltinExchangeType.FANOUT);

        // 每次启动都不同
        String queueName = channel.queueDeclare().getQueue();
        JaLog.info("queueName : {}", queueName);


        channel.queueBind(queueName, JaRabbitMQProducerTestFanout.ExchangeName, "");

        // 订阅模式下 设置公平消费, 默认是轮询模式[阻塞的pod会持续阻塞]
//        channel.basicQos(1);

        Consumer consumer = new DefaultConsumer(channel) {
            @SneakyThrows
            @Override
            public void handleDelivery(String consumerTag,
                                       Envelope envelope,
                                       AMQP.BasicProperties properties,
                                       byte[] body)
                    throws IOException {
                JaLog.info("body:{}, consumerTag:{}, envelope:{}, properties:{}", new String(body), consumerTag, envelope, properties);
                JaLog.info("body : {}", new String(body));
                Thread.sleep(10000L);

                channel.basicAck(envelope.getDeliveryTag(), false);
            }
        };

        channel.basicConsume(queueName, false, consumer);
        DwShutdownHookUtil.add(connectionName, () -> {
            try {
                channel.close();
                connection.close();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (TimeoutException e) {
                e.printStackTrace();
            }

        });


    }

    public static void main(String[] args) {
        consumer(JaRabbitMQProducerTestFanout.ExchangeName + "_" + 1);


//        for (int i = 0; i < 2; i++) {
//            int finalI = i;
//            JaThreadPool.execute(() -> {
//                consumer(JaRabbitMQProducerTestFanout.ExchangeName + "_" + finalI);
//            });
//        }
    }
}
