package com.digiwin.dap.nest.infrastructure.middleware.rabbitmq.test.fanout;

import com.digiwin.dap.nest.infrastructure.middleware.rabbitmq.test.TestConnectionFactory;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import lombok.SneakyThrows;

import java.nio.charset.StandardCharsets;

public class JaRabbitMQProducerTestFanout {

    public static final String ExchangeName = "exchange_fanout_test";
    private static final String ROUTING_KEY = "athena.ptm.message.atmc.test";
    private static final String QUEUE_NAME = "athena.ptm.message.atmc.test";

    @SneakyThrows
    public static void send(String message) {
        ConnectionFactory factory = TestConnectionFactory.get();

        try (Connection connection = factory.newConnection();
             Channel channel = connection.createChannel()) {


//            channel.queueDeclare()
//            channel.exchangeDelete("exchange_topic_test");
            channel.exchangeDeclare(ExchangeName, BuiltinExchangeType.FANOUT);
            channel.basicPublish(ExchangeName, "", null, message.getBytes(StandardCharsets.UTF_8));
            System.out.println("Sent message: " + message);

        }
    }

    public static void main(String[] args) {
        send("test fanout");
    }
}
