package com.digiwin.dap.nest.infrastructure.middleware.rabbitmq.context;

import com.digiwin.dap.nest.kernel.core.context.DwMapContextLink;
import com.digiwin.dap.nest.kernel.core.context.biz.DwCoreContextEntity;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;

import java.util.Map;

/**
 * 兼容
 *
 * @author chenjian
 * @since 2024年06月04日 19:27:44
 */
public class PinpointSourceContextLink implements DwMapContextLink<DwCoreContextEntity> {

    public static final String PinpointPAppNameKey = "Pinpoint-pAppName";

    @Override
    public void inherit(Map<String, String> source, DwCoreContextEntity target) {
        if (null == target.getUsName()) {
            String usName = source.get(PinpointPAppNameKey);
            if (DwStringUtil.isSafeNotEmpty(usName)) {
                target.setUsName(usName);
            }
        }
    }

    @Override
    public void transmit(DwCoreContextEntity source, Map<String, String> target) {
        // Do nothing
    }
}
