package com.digiwin.dap.nest.infrastructure.middleware.rabbitmq.config;

import com.digiwin.dap.nest.kernel.core.config.DwCenterPropertyHandler;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.reflect.clazz.JaClassUtil;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.DwNacosConfigPropertiesProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.config.DwNacosConfigService;

public class DwRabbitMQCenterPropertyHandler implements DwCenterPropertyHandler {
    @Override
    public void addAndCover() {
        /*
         * org.springframework.boot.autoconfigure.amqp.RabbitProperties
         */
        // 开启发送确认
        addAndCover("spring.rabbitmq.publisherConfirms", true);
        // 开启发送失败退回
        addAndCover("spring.rabbitmq.publisherReturns", true);
        addAndCover("spring.rabbitmq.template.mandatory", true);
        addAndCover("spring.rabbitmq.listener.type", "simple");
        // 开启消息消费手动确认
        addAndCover("spring.rabbitmq.listener.simple.acknowledgeMode", "manual");
        addAndCover("spring.rabbitmq.listener.simple.prefetch", 3);

        if (JaClassUtil.hashClass("config.com.digiwin.dap.nest.infrastructure.middleware.nacos.JaNacosConfigService")) {
            try {
                DwNacosConfigService.loadYaml("rabbitmq.yml", DwNacosConfigPropertiesProcessor.getNameSpaceCommon());
            } catch (Throwable e) {
                DwLog.error("rabbitmq nacos read error", e);
            }
        }
    }

    @Override
    public int order() {
        return -10;
    }
}
