package com.digiwin.dap.nest.infrastructure.middleware.rabbitmq.context;

import com.digiwin.dap.nest.kernel.core.context.DwMapContextLink;
import com.digiwin.dap.nest.kernel.core.context.biz.DwCoreContextEntity;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwMDC;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;

import java.util.Map;

/**
 * 兼容
 *
 * @author chenjian
 * @since 2024年06月04日 19:27:44
 */
public class PinpointTraceContextLink implements DwMapContextLink<DwCoreContextEntity> {

    public static final String PinpointTraceIDKey = "Pinpoint-TraceID";
    public static final String PinpointSpanIDKey = "Pinpoint-pSpanID";

    @Override
    public void inherit(Map<String, String> source, DwCoreContextEntity target) {
        String traceId = source.get(DwMDC.KeyTraceId);
        if (DwStringUtil.isEmpty(traceId)) {
            traceId = source.get(PinpointTraceIDKey);
            if (DwStringUtil.isNotEmpty(traceId)) {
                source.put(DwMDC.KeyTraceId, traceId);
            }
        }
        DwMDC.put(DwStringUtil.isEmpty(traceId) ? DwMDC.createTraceId() : traceId);

        String parentSpanId = source.get(DwMDC.KeyParentSpanId);
        if (DwStringUtil.isEmpty(parentSpanId)) {
            parentSpanId = source.get(PinpointSpanIDKey);
            if (DwStringUtil.isNotEmpty(parentSpanId)) {
                source.put(DwMDC.KeyTraceId, parentSpanId);
                DwMDC.putParentSpanId(parentSpanId);
            }
        }
    }

    @Override
    public void transmit(DwCoreContextEntity source, Map<String, String> target) {
        // Do nothing
    }

    @Override
    public int order() {
        return -1000;
    }
}
