//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package org.springframework.amqp.rabbit.listener.adapter;

import com.digiwin.dap.nest.infrastructure.middleware.rabbitmq.spring.DwNodeSpanRabbitListenerConsumer;
import com.rabbitmq.client.Channel;
import org.apache.commons.logging.Log;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.amqp.support.converter.RemoteInvocationResult;
import org.springframework.core.MethodParameter;
import org.springframework.expression.Expression;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.util.Assert;
import org.springframework.util.TypeUtils;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class MessagingMessageListenerAdapter extends AbstractAdaptableMessageListener {
    private HandlerAdapter handlerAdapter;
    private final MessagingMessageConverterAdapter messagingMessageConverter;
    private final boolean returnExceptions;
    private final RabbitListenerErrorHandler errorHandler;

    public MessagingMessageListenerAdapter() {
        this((Object) null, (Method) null);
    }

    public MessagingMessageListenerAdapter(Object bean, Method method) {
        this(bean, method, false, (RabbitListenerErrorHandler) null);
    }

    public MessagingMessageListenerAdapter(Object bean, Method method, boolean returnExceptions, RabbitListenerErrorHandler errorHandler) {
        this(bean, method, returnExceptions, errorHandler, false);
    }

    protected MessagingMessageListenerAdapter(Object bean, Method method, boolean returnExceptions, RabbitListenerErrorHandler errorHandler, boolean batch) {
        this.messagingMessageConverter = new MessagingMessageConverterAdapter(bean, method, batch);
        this.returnExceptions = returnExceptions;
        this.errorHandler = errorHandler;
    }

    public void setHandlerAdapter(HandlerAdapter handlerAdapter) {
        this.handlerAdapter = handlerAdapter;
    }

    protected HandlerAdapter getHandlerAdapter() {
        return this.handlerAdapter;
    }

    public boolean isAsyncReplies() {
        return this.handlerAdapter.isAsyncReplies();
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull(headerMapper, "HeaderMapper must not be null");
        this.messagingMessageConverter.setHeaderMapper(headerMapper);
    }

    protected final MessagingMessageConverter getMessagingMessageConverter() {
        return this.messagingMessageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        super.setMessageConverter(messageConverter);
        this.messagingMessageConverter.setPayloadConverter(messageConverter);
    }

    public void onMessage(org.springframework.amqp.core.Message amqpMessage, Channel channel) throws Exception {
        DwNodeSpanRabbitListenerConsumer.MessageThreadLocal.set(amqpMessage);
        DwNodeSpanRabbitListenerConsumer.ChannelThreadLocal.set(channel);
        Message<?> message = null;

        try {
            message = this.toMessagingMessage(amqpMessage);
            this.invokeHandlerAndProcessResult(amqpMessage, channel, message);
        } catch (ListenerExecutionFailedException ex) {
            this.handleException(amqpMessage, channel, message, ex);
        } catch (ReplyFailureException ex) {
            throw ex;
        } catch (Exception ex) {
            this.handleException(amqpMessage, channel, message, new ListenerExecutionFailedException("Failed to convert message", ex, new org.springframework.amqp.core.Message[]{amqpMessage}));
        }

    }

    protected void asyncFailure(org.springframework.amqp.core.Message request, Channel channel, Throwable t, Object source) {
        try {
            this.handleException(request, channel, (Message) source, new ListenerExecutionFailedException("Async Fail", t, new org.springframework.amqp.core.Message[]{request}));
        } catch (Exception var6) {
            super.asyncFailure(request, channel, t, source);
        }
    }

    private void handleException(org.springframework.amqp.core.Message amqpMessage, Channel channel, @Nullable Message<?> message, ListenerExecutionFailedException e) throws Exception {
        if (this.errorHandler != null) {
            try {
                Object errorResult = this.errorHandler.handleError(amqpMessage, channel, message, e);
                if (errorResult != null) {
                    Object payload = message == null ? null : message.getPayload();
                    InvocationResult invResult = payload == null ? new InvocationResult(errorResult, (Expression) null, (Type) null, (Object) null, (Method) null) : this.handlerAdapter.getInvocationResultFor(errorResult, payload);
                    this.handleResult(invResult, amqpMessage, channel, message);
                } else {
                    this.logger.trace("Error handler returned no result");
                }
            } catch (Exception ex) {
                this.returnOrThrow(amqpMessage, channel, message, ex, ex);
            }
        } else {
            this.returnOrThrow(amqpMessage, channel, message, e.getCause(), e);
        }

    }

    protected void invokeHandlerAndProcessResult(@Nullable org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message) throws Exception {
        boolean projectionUsed = amqpMessage == null ? false : amqpMessage.getMessageProperties().isProjectionUsed();
        if (projectionUsed) {
            amqpMessage.getMessageProperties().setProjectionUsed(false);
        }

        if (this.logger.isDebugEnabled() && !projectionUsed) {
            this.logger.debug("Processing [" + String.valueOf(message) + "]");
        }

        InvocationResult result = null;
        if (this.messagingMessageConverter.method == null && amqpMessage != null) {
            amqpMessage.getMessageProperties().setTargetMethod(this.handlerAdapter.getMethodFor(message.getPayload()));
        }

        result = this.invokeHandler(amqpMessage, channel, message);
        if (result.getReturnValue() != null) {
            this.handleResult(result, amqpMessage, channel, message);
        } else {
            this.logger.trace("No result object given - no result to handle");
        }

    }

    private void returnOrThrow(org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message, Throwable throwableToReturn, Exception exceptionToThrow) throws Exception {
        if (!this.returnExceptions) {
            throw exceptionToThrow;
        } else {
            Object payload = message == null ? null : message.getPayload();

            try {
                this.handleResult(new InvocationResult(new RemoteInvocationResult(throwableToReturn), (Expression) null, (Type) (payload == null ? Object.class : this.handlerAdapter.getReturnTypeFor(payload)), this.handlerAdapter.getBean(), payload == null ? null : this.handlerAdapter.getMethodFor(payload)), amqpMessage, channel, message);
            } catch (ReplyFailureException rfe) {
                if (payload != null && !Void.TYPE.equals(this.handlerAdapter.getReturnTypeFor(payload))) {
                    throw rfe;
                } else {
                    throw exceptionToThrow;
                }
            }
        }
    }

    protected Message<?> toMessagingMessage(org.springframework.amqp.core.Message amqpMessage) {
        return (Message) this.getMessagingMessageConverter().fromMessage(amqpMessage);
    }

    protected InvocationResult invokeHandler(@Nullable org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message) {
        try {
            return amqpMessage == null ? this.handlerAdapter.invoke(message, new Object[]{channel}) : this.handlerAdapter.invoke(message, new Object[]{amqpMessage, channel, amqpMessage.getMessageProperties()});
        } catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), ex, new org.springframework.amqp.core.Message[]{amqpMessage});
        } catch (Exception ex) {
            HandlerAdapter var10002 = this.handlerAdapter;
            throw new ListenerExecutionFailedException("Listener method '" + var10002.getMethodAsString(message.getPayload()) + "' threw exception", ex, new org.springframework.amqp.core.Message[]{amqpMessage});
        }
    }

    private String createMessagingErrorMessage(String description, Object payload) {
        return description + "\nEndpoint handler details:\nMethod [" + this.handlerAdapter.getMethodAsString(payload) + "]\nBean [" + String.valueOf(this.handlerAdapter.getBean()) + "]";
    }

    protected org.springframework.amqp.core.Message buildMessage(Channel channel, Object result, Type genericType) {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null && !(result instanceof org.springframework.amqp.core.Message)) {
            return result instanceof Message ? this.messagingMessageConverter.toMessage(result, new MessageProperties()) : this.convert(result, genericType, converter);
        } else if (result instanceof org.springframework.amqp.core.Message) {
            org.springframework.amqp.core.Message msg = (org.springframework.amqp.core.Message) result;
            return msg;
        } else {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + String.valueOf(result) + "]");
        }
    }

    protected final class MessagingMessageConverterAdapter extends MessagingMessageConverter {
        private final Object bean;
        final Method method;
        private final Type inferredArgumentType;
        private final boolean isBatch;
        private boolean isMessageList;
        private boolean isAmqpMessageList;
        private boolean isCollection;

        MessagingMessageConverterAdapter(Object bean, Method method, boolean batch) {
            this.bean = bean;
            this.method = method;
            this.isBatch = batch;
            this.inferredArgumentType = this.determineInferredType();
            if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled() && this.inferredArgumentType != null) {
                Log var10000 = MessagingMessageListenerAdapter.this.logger;
                String var10001 = method.toString();
                var10000.debug("Inferred argument type for " + var10001 + " is " + String.valueOf(this.inferredArgumentType));
            }

        }

        protected boolean isMessageList() {
            return this.isMessageList;
        }

        protected boolean isAmqpMessageList() {
            return this.isAmqpMessageList;
        }

        protected Method getMethod() {
            return this.method;
        }

        protected Object extractPayload(org.springframework.amqp.core.Message message) {
            MessageProperties messageProperties = message.getMessageProperties();
            if (this.bean != null) {
                messageProperties.setTargetBean(this.bean);
            }

            if (this.method != null) {
                messageProperties.setTargetMethod(this.method);
                if (this.inferredArgumentType != null) {
                    messageProperties.setInferredArgumentType(this.inferredArgumentType);
                }
            }

            return MessagingMessageListenerAdapter.this.extractMessage(message);
        }

        private Type determineInferredType() {
            if (this.method == null) {
                return null;
            } else {
                Type genericParameterType = null;

                for (int i = 0; i < this.method.getParameterCount(); ++i) {
                    MethodParameter methodParameter = new MethodParameter(this.method, i);
                    boolean isHeaderOrHeaders = methodParameter.hasParameterAnnotation(Header.class) || methodParameter.hasParameterAnnotation(Headers.class) || methodParameter.getParameterType().equals(MessageHeaders.class);
                    boolean isPayload = methodParameter.hasParameterAnnotation(Payload.class);
                    if (isHeaderOrHeaders && isPayload && MessagingMessageListenerAdapter.this.logger.isWarnEnabled()) {
                        MessagingMessageListenerAdapter.this.logger.warn(this.method.getName() + ": Cannot annotate a parameter with both @Header and @Payload; ignored for payload conversion");
                    }

                    if (this.isEligibleParameter(methodParameter) && (!isHeaderOrHeaders || isPayload) && (!isHeaderOrHeaders || !isPayload)) {
                        if (genericParameterType != null) {
                            if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled()) {
                                MessagingMessageListenerAdapter.this.logger.debug("Ambiguous parameters for target payload for method " + String.valueOf(this.method) + "; no inferred type header added");
                            }

                            return null;
                        }

                        genericParameterType = this.extractGenericParameterTypFromMethodParameter(methodParameter);
                        if (this.isBatch && !this.isCollection) {
                            throw new IllegalStateException("Mis-configuration; a batch listener must consume a List<?> or Collection<?> for method: " + String.valueOf(this.method));
                        }
                    }
                }

                return this.checkOptional(genericParameterType);
            }
        }

        protected Type checkOptional(Type genericParameterType) {
            if (genericParameterType instanceof ParameterizedType pType) {
                if (pType.getRawType().equals(Optional.class)) {
                    return pType.getActualTypeArguments()[0];
                }
            }

            return genericParameterType;
        }

        private boolean isEligibleParameter(MethodParameter methodParameter) {
            Type parameterType = methodParameter.getGenericParameterType();
            if (!parameterType.equals(Channel.class) && !parameterType.equals(MessageProperties.class) && !parameterType.equals(org.springframework.amqp.core.Message.class) && !parameterType.getTypeName().startsWith("kotlin.coroutines.Continuation")) {
                if (parameterType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType) parameterType;
                    if (parameterizedType.getRawType().equals(Message.class)) {
                        return !(parameterizedType.getActualTypeArguments()[0] instanceof WildcardType);
                    }
                }

                return !parameterType.equals(Message.class);
            } else {
                return false;
            }
        }

        private Type extractGenericParameterTypFromMethodParameter(MethodParameter methodParameter) {
            Type genericParameterType = methodParameter.getGenericParameterType();
            if (genericParameterType instanceof ParameterizedType parameterizedType) {
                if (parameterizedType.getRawType().equals(Message.class)) {
                    genericParameterType = ((ParameterizedType) genericParameterType).getActualTypeArguments()[0];
                } else if (this.isBatch && (parameterizedType.getRawType().equals(List.class) || parameterizedType.getRawType().equals(Collection.class) && parameterizedType.getActualTypeArguments().length == 1)) {
                    Type paramType;
                    boolean var10000;
                    label32:
                    {
                        this.isCollection = true;
                        paramType = parameterizedType.getActualTypeArguments()[0];
                        if (paramType instanceof ParameterizedType) {
                            ParameterizedType pType = (ParameterizedType) paramType;
                            if (pType.getRawType().equals(Message.class)) {
                                var10000 = true;
                                break label32;
                            }
                        }

                        var10000 = false;
                    }

                    boolean messageHasGeneric = var10000;
                    this.isMessageList = TypeUtils.isAssignable(paramType, Message.class) || messageHasGeneric;
                    this.isAmqpMessageList = TypeUtils.isAssignable(paramType, org.springframework.amqp.core.Message.class);
                    if (messageHasGeneric) {
                        genericParameterType = ((ParameterizedType) paramType).getActualTypeArguments()[0];
                    } else {
                        genericParameterType = paramType;
                    }
                }
            }

            return genericParameterType;
        }
    }
}
