package com.jugg.agile.middleware.db.mybatis.page;

import com.jugg.agile.framework.core.util.concurrent.JaThreadPool;
import com.jugg.agile.framework.meta.JaReturn2;
import com.jugg.agile.framework.meta.dto.JaPageReqDTO;
import com.jugg.agile.framework.meta.function.JaFunctionR;
import lombok.SneakyThrows;

import java.util.List;
import java.util.concurrent.Future;

public class JaMybatisPage {

    private JaMybatisPage() {
    }

    public static final ThreadLocal<JaMybatisPageContext> PageThreadLocal = new ThreadLocal<>();

    public static <T> JaReturn2<Long, List<T>> page(JaPageReqDTO pageReqDTO, JaFunctionR<List<T>> functionR) {
        return page(pageReqDTO.getPageSize(), pageReqDTO.getPageIndex(), functionR);
    }

    @SneakyThrows
    public static <T> JaReturn2<Long, List<T>> page(Integer pageSize, Integer pageIndex, JaFunctionR<List<T>> functionR) {
        Future<List<T>> pageFuture = JaThreadPool.submit(() -> {
            PageThreadLocal.set(JaMybatisPageContext.builder().isCount(false).pageSize(pageSize).pageIndex(pageIndex).build());
            try {
                return functionR.apply();
            } finally {
                PageThreadLocal.remove();
            }

        });
        Future<Long> countFuture = JaThreadPool.submit(() -> {
            PageThreadLocal.set(JaMybatisPageContext.builder().isCount(true).pageSize(pageSize).pageIndex(pageIndex).build());
            try {
                functionR.apply();
                return PageThreadLocal.get().getCount();
            } finally {
                PageThreadLocal.remove();
            }

        });

        return new JaReturn2<>(countFuture.get(), pageFuture.get());
    }

}