package com.jugg.agile.middleware.db.datasource;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.reflect.JaReflectUtil;
import com.jugg.agile.middleware.db.datasource.config.JaDataSourceConfig;
import com.jugg.agile.middleware.db.datasource.config.JaDataSourcePoolConfig;
import com.jugg.agile.middleware.db.datasource.hikari.JaHikariDataSourceProcessor;
import com.jugg.agile.middleware.db.jdbc.JaJdbcUrlProcessor;
import com.jugg.agile.middleware.db.jdbc.config.JdbcPropertyConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.SneakyThrows;

import javax.sql.DataSource;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JaDataSourceFactory {

    private static Map<String, DataSource> dataSourcePool = null;

    public static Map<String, DataSource> get() {
        return dataSourcePool;
    }

    public static synchronized void create() {
        if (null == dataSourcePool) {
            dataSourcePool = new ConcurrentHashMap<>();
        }
        JaDataSourcePoolConfig dataSourcePoolConfig = JaYamlProcessor.getConfig("ja.datasource", JaDataSourcePoolConfig.class);
        dataSourcePoolConfig.getPool().forEach((name, dataSourceConfig) -> {
            if (!dataSourcePool.containsKey(name)) {
                HikariDataSource dataSource = JaHikariDataSourceProcessor.create(name, dataSourceConfig);
                dataSourcePool.put(name, dataSource);
                JaShutdownHookUtil.add("DataSource-" + name, dataSource::close);
            }
        });
    }

    @SneakyThrows
    public static String getJdbcUrl(JaDataSourceConfig dataSourceConfig) {
        if (JaStringUtil.isNotEmpty(dataSourceConfig.getJdbcUrl())) {
            return dataSourceConfig.getJdbcUrl();
        }
        return JaJdbcUrlProcessor.get(dataSourceConfig.getIp()
                , dataSourceConfig.getPort()
                , dataSourceConfig.getDatabase()
                , dataSourceConfig.getJdbcUrlParam());
    }

    @SneakyThrows
    public static Map<String, Object> getJdbcProperty(JaDataSourceConfig dataSourceConfig) {
        JdbcPropertyConfig property = dataSourceConfig.getJdbcProperty();
        List<Field> allFields = JaReflectUtil.getAllFields(JdbcPropertyConfig.class);
        Map<String, Object> map = new HashMap<>(allFields.size());
        for (Field field : allFields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(property));
        }
        return map;
    }

    public static void main(String[] args) {
        Map<String, Object> map = JaProperty.getPropertyMap();
        map.put("ja.datasource.pool.slaver.database", "drp_infrastructure_server");
        map.put("ja.datasource.pool.slaver.ip", "10.79.3.255");
        map.put("ja.datasource.pool.slaver.port", "33066");
        map.put("ja.datasource.pool.slaver.username", "drp_common");

        map.put("ja.datasource.pool.master.database", "drp_infrastructure_server");
        map.put("ja.datasource.pool.master.ip", "10.79.3.255");
        map.put("ja.datasource.pool.master.port", "33066");
        map.put("ja.datasource.pool.master.username", "drp_common");
        JaDataSourcePoolConfig config = JaYamlProcessor.getConfig("ja.datasource", JaDataSourcePoolConfig.class);
        System.out.println();
    }
}


