package com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc;

import com.digiwin.dap.nest.kernel.meta.function.JaFunctionTP;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * jdbc Statement 处理器
 *
 * @author chenjian
 * @since 2024年03月31日 20:13:53
 */
public class JaJdbcStatementProcessor {

    public static List<Map<String, Object>> executeQuery(Connection connection, String sql) {
        try (Statement stmt = connection.createStatement()) {
            List<Map<String, Object>> tables = new ArrayList<>();
            JaJdbcResultSetProcessor.get(stmt.executeQuery(sql), tables);
            return tables;
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void executeQuery(Connection connection, String sql, JaFunctionTP<ResultSet> jaFunctionP) {
        try (Statement stmt = connection.createStatement()) {
            jaFunctionP.apply(stmt.executeQuery(sql));
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void executeQueryByRow(Connection connection, String sql, JaFunctionTP<ResultSet> jaFunctionP) {
        try (Statement stmt = connection.createStatement()) {
            ResultSet resultSet = stmt.executeQuery(sql);
            while (resultSet.next()) {
                jaFunctionP.apply(resultSet);
            }
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

}
