/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.config.JaDataSourceConfig;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.config.JaDataSourcePoolConfig;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.hikari.JaHikariDataSourceProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.JaJdbcUrlProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.config.JdbcPropertyConfig;
import com.digiwin.dap.nest.kernel.core.config.processor.JaYamlProcessor;
import com.digiwin.dap.nest.kernel.core.util.DwShutdownHookUtil;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.reflect.JaReflectUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class JaDataSourceFactory {
    private static Map<String, DataSource> dataSourcePool = null;

    private JaDataSourceFactory() {
    }

    public static Map<String, DataSource> get() {
        return dataSourcePool;
    }

    public static synchronized void create() {
        if (null == dataSourcePool) {
            dataSourcePool = new ConcurrentHashMap<String, DataSource>();
        }
        JaDataSourcePoolConfig dataSourcePoolConfig = (JaDataSourcePoolConfig)JaYamlProcessor.getConfig((String)"dw.datasource", JaDataSourcePoolConfig.class);
        dataSourcePoolConfig.getPool().forEach((name, dataSourceConfig) -> {
            if (!dataSourcePool.containsKey(name)) {
                HikariDataSource dataSource = JaHikariDataSourceProcessor.create(name, dataSourceConfig);
                dataSourcePool.put((String)name, (DataSource)dataSource);
                DwShutdownHookUtil.add((String)("DataSource-" + name), () -> ((HikariDataSource)dataSource).close());
            }
        });
    }

    public static String getJdbcUrl(JaDataSourceConfig dataSourceConfig) {
        if (DwStringUtil.isNotEmpty((String)dataSourceConfig.getJdbcUrl())) {
            return dataSourceConfig.getJdbcUrl();
        }
        return JaJdbcUrlProcessor.get(dataSourceConfig.getIp(), dataSourceConfig.getPort(), dataSourceConfig.getDatabase(), dataSourceConfig.getJdbcUrlParam());
    }

    public static Map<String, Object> getJdbcProperty(JaDataSourceConfig dataSourceConfig) {
        JdbcPropertyConfig property = dataSourceConfig.getJdbcProperty();
        List allFields = JaReflectUtil.getAllFields(JdbcPropertyConfig.class);
        HashMap<String, Object> map = new HashMap<String, Object>(allFields.size());
        for (Field field : allFields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(property));
        }
        return map;
    }
}

