package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource;

import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.util.JaThrowableUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect.JaConnectionAspect;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect.JaDataSourceAspect;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Primary;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;
import java.util.Map;

@Configuration
@ConditionalOnProperty(name = DwConfig.KeyPrefix + "datasource.enabled", havingValue = "true")
@AutoConfigureBefore(DataSourceAutoConfiguration.class)
public class JaDataSourceConfiguration implements InitializingBean {
    @Bean
    @Primary
    @ConditionalOnMissingBean({DataSource.class})
    public DataSource dataSource() {
        JaDataSourceFactory.create();
        Map<String, DataSource> dataSourceMap = JaDataSourceFactory.get();
        if (JaCollectionUtil.isEmpty(dataSourceMap)) {
            JaThrowableUtil.throwRunLog("dataSourceMap is empty");
        }
        DataSource dataSource = dataSourceMap.get("default");
        if (null == dataSource) {
            dataSource = dataSourceMap.entrySet().iterator().next().getValue();
        }
        return dataSource;
    }

    @Bean
    public JaDataSourceAspect dataSourceAspect() {
        return new JaDataSourceAspect();
    }

    @Bean
    public JaConnectionAspect connectionAspect() {
        return new JaConnectionAspect();
    }

    @Override
    public void afterPropertiesSet() {
        if (null == JaDataSourceFactory.get()) {
            JaDataSourceFactory.create();
        }
    }
}
