package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource;

import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.config.processor.JaYamlProcessor;
import com.digiwin.dap.nest.kernel.core.util.DwShutdownHookUtil;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.reflect.JaReflectUtil;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.config.JaDataSourceConfig;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.config.JaDataSourcePoolConfig;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.hikari.JaHikariDataSourceProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.JaJdbcUrlProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.config.JdbcPropertyConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.SneakyThrows;

import javax.sql.DataSource;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JaDataSourceFactory {

    private JaDataSourceFactory() {
    }

    private static Map<String, DataSource> dataSourcePool = null;

    public static Map<String, DataSource> get() {
        return dataSourcePool;
    }

    public static synchronized void create() {
        if (null == dataSourcePool) {
            dataSourcePool = new ConcurrentHashMap<>();
        }
        JaDataSourcePoolConfig dataSourcePoolConfig = JaYamlProcessor.getConfig(DwConfig.KeyPrefix + "datasource", JaDataSourcePoolConfig.class);
        dataSourcePoolConfig.getPool().forEach((name, dataSourceConfig) -> {
            if (!dataSourcePool.containsKey(name)) {
                HikariDataSource dataSource = JaHikariDataSourceProcessor.create(name, dataSourceConfig);
                dataSourcePool.put(name, dataSource);
                DwShutdownHookUtil.add("DataSource-" + name, dataSource::close);
            }
        });
    }

    @SneakyThrows
    public static String getJdbcUrl(JaDataSourceConfig dataSourceConfig) {
        if (DwStringUtil.isNotEmpty(dataSourceConfig.getJdbcUrl())) {
            return dataSourceConfig.getJdbcUrl();
        }
        return JaJdbcUrlProcessor.get(dataSourceConfig.getIp()
                , dataSourceConfig.getPort()
                , dataSourceConfig.getDatabase()
                , dataSourceConfig.getJdbcUrlParam());
    }

    @SneakyThrows
    public static Map<String, Object> getJdbcProperty(JaDataSourceConfig dataSourceConfig) {
        JdbcPropertyConfig property = dataSourceConfig.getJdbcProperty();
        List<Field> allFields = JaReflectUtil.getAllFields(JdbcPropertyConfig.class);
        Map<String, Object> map = new HashMap<>(allFields.size());
        for (Field field : allFields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(property));
        }
        return map;
    }
}


