/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.page;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.page.JaMybatisPageContext;
import com.digiwin.dap.nest.kernel.core.util.concurrent.JaThreadPool;
import com.digiwin.dap.nest.kernel.meta.JaReturn2;
import com.digiwin.dap.nest.kernel.meta.dto.DwPageReqDTO;
import com.digiwin.dap.nest.kernel.meta.function.JaFunctionR;
import java.util.List;
import java.util.concurrent.Future;

public class JaMybatisPage {
    public static final ThreadLocal<JaMybatisPageContext> PageThreadLocal = new ThreadLocal();

    private JaMybatisPage() {
    }

    public static <T> JaReturn2<Long, List<T>> page(DwPageReqDTO pageReqDTO, JaFunctionR<List<T>> functionR) {
        return JaMybatisPage.page(pageReqDTO.getPageSize(), pageReqDTO.getPageIndex(), functionR);
    }

    public static <T> JaReturn2<Long, List<T>> page(Integer pageSize, Integer pageIndex, JaFunctionR<List<T>> functionR) {
        Future pageFuture = JaThreadPool.submit(() -> {
            PageThreadLocal.set(JaMybatisPageContext.builder().isCount(false).pageSize(pageSize).pageIndex(pageIndex).build());
            try {
                List list = (List)functionR.apply();
                return list;
            }
            finally {
                PageThreadLocal.set(null);
                PageThreadLocal.remove();
            }
        });
        Future countFuture = JaThreadPool.submit(() -> {
            PageThreadLocal.set(JaMybatisPageContext.builder().isCount(true).pageSize(pageSize).pageIndex(pageIndex).build());
            try {
                functionR.apply();
                Long l = PageThreadLocal.get().getCount();
                return l;
            }
            finally {
                PageThreadLocal.set(null);
                PageThreadLocal.remove();
            }
        });
        return new JaReturn2((Object)((Long)countFuture.get()), (Object)((List)pageFuture.get()));
    }
}

