package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect;

import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.util.bytecode.aop.JaAspectUtil;
import com.digiwin.dap.nest.kernel.core.util.io.serialize.json.DwJson;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.JaDataSourceRoute;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.meta.JaDataSource;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.meta.JaDataSourceAnnotation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * 数据源标示切换
 *
 * @author chenjian
 * @since 2023年06月13日 10:18:18
 */
@Aspect
@Order(Ordered.HIGHEST_PRECEDENCE)
public class JaDataSourceAspect {

    @Pointcut("@within(com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.meta.JaDataSource) "
            + "|| @annotation(com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.meta.JaDataSource)"
    )
    public void pointcut() {
    }

    @Around("pointcut()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        JaDataSource annotation = JaAspectUtil.getAnnotation(pjp, JaDataSource.class);
        JaDataSourceAnnotation backUp = null;
        if (null != annotation) {
            backUp = JaDataSourceRoute.getRoute().get();
            JaDataSourceAnnotation dataSourceAnnotation = JaDataSourceAnnotation.converter(annotation);
            JaDataSourceRoute.getRoute().set(dataSourceAnnotation);
            JaLog.get().debug("datasource route info : {}", DwJson.toString(dataSourceAnnotation));
        }
        try {
            return pjp.proceed();
        } finally {
            if (null != annotation) {
                if (null == backUp) {
                    JaDataSourceRoute.getRoute().remove();
                } else {
                    JaDataSourceRoute.getRoute().set(backUp);
                }

            }
        }

    }
}
