package com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.generator;

import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.JaJdbcConnectionProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.mysql.JaMysqlShowProcessor;
import lombok.SneakyThrows;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.File;
import java.sql.Connection;
import java.util.List;

/**
 *
 */
@Deprecated
public class JaMybatisGeneratorXmlW3c {

    /**
     * 添加 table 节点
     *
     * @param path                   xml路径, 列: agile/middleware/jugg-agile-db/src/main/resources/generatorConfig.xml
     * @param domainObjectNameSuffix 列:PO
     * @param mapperNameSuffix       列:Mapper
     */
    @SneakyThrows
    public static void addAllTableNode(String path, String domainObjectNameSuffix, String mapperNameSuffix) {

        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        File file = new File(path);
        Document doc = docBuilder.parse(file);

        Node context = doc.getElementsByTagName("context").item(0);
        Element jdbcConnection = (Element) doc.getElementsByTagName("jdbcConnection").item(0);
        String connectionURL = jdbcConnection.getAttribute("connectionURL");
        String userId = jdbcConnection.getAttribute("userId");
        String password = jdbcConnection.getAttribute("password");
        Connection connection = JaJdbcConnectionProcessor.get(connectionURL, userId, password);
        List<String> tableNameList = JaMysqlShowProcessor.showTables(connection, connection.getSchema());
        connection.close();

        NodeList tableNodes = doc.getElementsByTagName("table");
        int length = tableNodes.getLength();
        for (int i = 0; i < length; i++) {
            context.removeChild(tableNodes.item(0));
        }

        tableNameList.forEach(tableName -> {
            Element newTableElement = doc.createElement("table");
            String toCamelCase = DwStringUtil.upperFirstCase(DwStringUtil.underscoreToCamelCase(tableName));
            System.out.println(toCamelCase);
            newTableElement.setAttribute("tableName", tableName);
            newTableElement.setAttribute("domainObjectName", toCamelCase + domainObjectNameSuffix);
            newTableElement.setAttribute("mapperName", toCamelCase + mapperNameSuffix);
            context.appendChild(newTableElement);
        });

        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute(XMLConstants.ACCESS_EXTERNAL_DTD, "");
        transformerFactory.setAttribute(XMLConstants.ACCESS_EXTERNAL_STYLESHEET, "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
        transformer.reset();
    }


    public static void main(String[] args) throws Throwable {
        addAllTableNode("agile/middleware/jugg-agile-db/src/main/resources/generatorConfig.xml", "PO", "Mapper");
    }
}
