/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.rdb.dapper;

import com.digiwin.dap.nest.infrastructure.spring.util.JaSpringContextUtil;
import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspectPointcut;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaNodeSpanResolver;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInvocation;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.annotation.MapperScans;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnClass(name={"org.mybatis.spring.annotation.MapperScan", "org.apache.ibatis.binding.MapperProxy"})
public class JaNodeSpanMybatis
implements JaNodeSpanResolver,
JaDapperAspectPointcut {
    public static final String ProxyClassName = "org.apache.ibatis.binding.MapperProxy";

    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        Object proxy;
        if (invocation instanceof ReflectiveMethodInvocation && (proxy = ((ReflectiveMethodInvocation)invocation).getProxy()).toString().startsWith(ProxyClassName)) {
            return this.get(NodeKind.Constant.Db);
        }
        return null;
    }

    public String getExpression() {
        String expression = DwConfig.get((String)"dapper.aspect.pointcut.mybatis");
        if (DwStringUtil.isNotEmpty((String)expression)) {
            return expression + " || @within(org.apache.ibatis.annotations.Mapper)";
        }
        ArrayList<String> basePackages = new ArrayList<String>(this.addBasePackages(JaSpringContextUtil.getMainApplicationClass()));
        HashSet basePackageSet = new HashSet();
        basePackages.forEach(s -> basePackageSet.addAll(Arrays.asList(s.split(","))));
        if (basePackageSet.size() > 1) {
            JaLog.get().warn("multiple mybatis mapper scan package");
        }
        StringBuilder expressionBuilder = new StringBuilder();
        for (String s2 : basePackageSet) {
            expressionBuilder.append(String.format("execution(* %s..*.*(..)) || ", s2));
        }
        return String.valueOf(expressionBuilder) + "@within(org.apache.ibatis.annotations.Mapper)";
    }

    private List<String> addBasePackages(Class<?> importingClass) {
        ArrayList<String> basePackages = new ArrayList<String>();
        MapperScans mapperScans = importingClass.getAnnotation(MapperScans.class);
        if (null != mapperScans) {
            basePackages.addAll(this.addBasePackages(mapperScans, importingClass));
        } else {
            MapperScan mapperScan = importingClass.getAnnotation(MapperScan.class);
            if (null != mapperScan) {
                basePackages.addAll(this.addBasePackages(mapperScan, importingClass));
            }
        }
        return basePackages;
    }

    private List<String> addBasePackages(MapperScans mapperScans, Class<?> importingClass) {
        ArrayList<String> basePackages = new ArrayList<String>();
        if (JaCollectionUtil.isEmpty((Object[])mapperScans.value())) {
            basePackages.add(ClassUtils.getPackageName((String)importingClass.getName()));
        } else {
            for (MapperScan mapperScan : mapperScans.value()) {
                basePackages.addAll(this.addBasePackages(mapperScan, importingClass));
            }
        }
        return basePackages;
    }

    private List<String> addBasePackages(MapperScan annotation, Class<?> importingClass) {
        ArrayList<String> basePackages = new ArrayList<String>();
        basePackages.addAll(Arrays.stream(annotation.value()).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annotation.basePackages()).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annotation.basePackageClasses()).map(ClassUtils::getPackageName).collect(Collectors.toList()));
        if (JaCollectionUtil.isEmpty(basePackages)) {
            basePackages.add(ClassUtils.getPackageName(importingClass));
        }
        return basePackages;
    }
}

