package com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.mysql;

import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.JaJdbcStatementProcessor;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

/**
 * show
 *
 * @author chenjian
 * @since 2024年03月31日 20:13:11
 */
public class JaMysqlShowProcessor {
    private JaMysqlShowProcessor() {
    }

    public static List<String> showTables(Connection connection, String... schema) {
        String sql = "show tables";
        if (JaCollectionUtil.isNotEmpty(schema)) {
            sql += " from `" + schema[0] + "`";
        }
        ArrayList<String> tables = new ArrayList<>();
        JaJdbcStatementProcessor.executeQueryByRow(connection
                , sql
                , resultSet -> tables.add(resultSet.getString(1)));
        return tables;
    }
}
