/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.JaDataSourceFactory;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect.JaConnectionAspect;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect.JaDataSourceAspect;
import com.digiwin.dap.nest.kernel.core.util.JaThrowableUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(name={"dw.datasource.enabled"}, havingValue="true")
public class JaDataSourceConfiguration
implements InitializingBean {
    @Bean
    @Primary
    @ConditionalOnMissingBean(value={DataSource.class})
    public DataSource dataSource() {
        DataSource dataSource;
        JaDataSourceFactory.create();
        Map<String, DataSource> dataSourceMap = JaDataSourceFactory.get();
        if (JaCollectionUtil.isEmpty(dataSourceMap)) {
            JaThrowableUtil.throwRunLog((String)"dataSourceMap is empty", (Object[])new Object[0]);
        }
        if (null == (dataSource = dataSourceMap.get("default"))) {
            dataSource = dataSourceMap.entrySet().iterator().next().getValue();
        }
        return dataSource;
    }

    @Bean
    public JaDataSourceAspect dataSourceAspect() {
        return new JaDataSourceAspect();
    }

    @Bean
    public JaConnectionAspect connectionAspect() {
        return new JaConnectionAspect();
    }

    public void afterPropertiesSet() {
        if (null == JaDataSourceFactory.get()) {
            JaDataSourceFactory.create();
        }
    }
}

