package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect;

import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.bytecode.aop.JaAspectUtil;
import com.digiwin.dap.nest.kernel.core.util.io.serialize.json.DwJson;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.DwDataSourceRoute;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.meta.DwDataSource;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.meta.DwDataSourceAnnotation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * 数据源标示切换
 *
 * @author chenjian
 * @since 2023年06月13日 10:18:18
 */
@Aspect
@Order(Ordered.HIGHEST_PRECEDENCE)
public class DwDataSourceAspect {

    @Pointcut("@within(com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.meta.DwDataSource) "
            + "|| @annotation(com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.meta.DwDataSource)"
    )
    public void pointcut() {
    }

    @Around("pointcut()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        DwDataSource annotation = JaAspectUtil.getAnnotation(pjp, DwDataSource.class);
        DwDataSourceAnnotation backUp = null;
        if (null != annotation) {
            backUp = DwDataSourceRoute.getRoute().get();
            DwDataSourceAnnotation dataSourceAnnotation = DwDataSourceAnnotation.converter(annotation);
            DwDataSourceRoute.getRoute().set(dataSourceAnnotation);
            DwLog.get().debug("datasource route info : {}", DwJson.toString(dataSourceAnnotation));
        }
        try {
            return pjp.proceed();
        } finally {
            if (null != annotation) {
                if (null == backUp) {
                    DwDataSourceRoute.getRoute().remove();
                } else {
                    DwDataSourceRoute.getRoute().set(backUp);
                }

            }
        }

    }
}
