package com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.mysql;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.DwJdbcStatementProcessor;

import java.sql.Connection;
import java.util.List;
import java.util.Map;

/**
 * desc
 *
 * @author chenjian
 * @since 2024年03月31日 20:12:56
 */
public class DwMysqlDescProcessor {

    private DwMysqlDescProcessor() {
    }

    public static List<Map<String, Object>> descTable(Connection connection, String tableName) {
        return DwJdbcStatementProcessor.executeQuery(connection
                , String.format("desc `%s`", tableName));
    }

    public static String getAutoIncrementColumn(Connection connection, String tableName) {
        List<Map<String, Object>> tableInfo = DwMysqlDescProcessor.descTable(connection, tableName);
        for (Map<String, Object> rowInfo : tableInfo) {
            Object exrta = rowInfo.get("EXTRA");// 5.0
            if (null == exrta) {//8.0
                exrta = rowInfo.get("Extra");
            }

            if (null != exrta && exrta.toString().contains("auto_increment")) {
                Object column_name = rowInfo.get("COLUMN_NAME");// 5.0
                if (null != column_name) {
                    return column_name.toString();
                }
                column_name = rowInfo.get("Field");//8.0
                if (null != column_name) {
                    return column_name.toString();
                }
            }
        }
        return null;
    }
}
