package com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.generator;

import lombok.SneakyThrows;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.internal.DefaultShellCallback;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * https://mybatis.org/generator/configreference/generatedKey.html
 * https://mybatis.org/generator/configreference/table.html
 */
public class DwMybatisGenerator {
    private DwMybatisGenerator() {
    }

    /**
     * 刷新 generator.xml, 重新生成mapper相关类
     *
     * @author chenjian
     * @since 2024年03月31日 20:15:08
     */
    public static void generateRefresh(JaMybatisGeneratorXmlParams xmlParams) {
        JaMybatisGeneratorXmlDom4j.initGeneratorXml(xmlParams);
        generate(xmlParams.getXmlPath());
    }


    /**
     * 不刷新 generator.xml, 重新生成mapper相关类
     *
     * @author chenjian
     * @since 2024年03月31日 20:15:26
     */
    @SneakyThrows
    public static void generate(String path) {
        List<String> warnings = new ArrayList<>();
        ConfigurationParser cp = new ConfigurationParser(warnings);
        ClassLoader classLoader = DwMybatisGenerator.class.getClassLoader();

        // 当前工程用getResource
//        Configuration config = cp.parseConfiguration(new File(Objects.requireNonNull(classLoader.getResource("generatorConfig.xml")).getFile()));
        // jar中用
//        Configuration config = cp.parseConfiguration(XmlReader.class.getResourceAsStream("/generatorConfig.xml"));

        // resources
        Configuration config = cp.parseConfiguration(new File(path));

        DefaultShellCallback callback = new DefaultShellCallback(true);
        MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, callback, warnings);
        myBatisGenerator.generate(null);
    }

    public static String getMysqlJarPath() {
        String classPath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        String[] paths = classPath.split(pathSeparator);

        for (String path : paths) {
            // mysql-connector-java 会重定向成 mysql-connector-j
            if (path.contains("mysql-connector-j")) {
                return path;
            }
        }
        return null;
    }
}
