/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.interceptor;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.page.DwMybatisPage;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.page.DwMybatisPageProcessor;
import java.sql.Connection;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
@Component
public class JaMybatisInterceptor
implements Interceptor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object intercept(Invocation invocation) throws Throwable {
        if (null == DwMybatisPage.PageThreadLocal.get()) return invocation.proceed();
        Object[] args = invocation.getArgs();
        Object target = invocation.getTarget();
        Object parameter = null;
        if (target instanceof StatementHandler) {
            Object delegate = target instanceof RoutingStatementHandler ? target : SystemMetaObject.forObject((Object)target).getValue("delegate");
            BoundSql boundSql = (BoundSql)SystemMetaObject.forObject((Object)delegate).getValue("boundSql");
            MappedStatement mappedStatement = (MappedStatement)SystemMetaObject.forObject((Object)delegate).getValue("mappedStatement");
            if (SqlCommandType.SELECT != mappedStatement.getSqlCommandType()) return invocation.proceed();
            parameter = boundSql.getParameterObject();
            DwMybatisPageProcessor.executePage(boundSql);
            return invocation.proceed();
        } else {
            parameter = args[1];
            if (target instanceof Executor && args.length == 2) {
                MappedStatement mappedStatement = (MappedStatement)args[0];
                SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
                if (SqlCommandType.INSERT != sqlCommandType && SqlCommandType.UPDATE != sqlCommandType) return invocation.proceed();
            }
            DwMybatisPageProcessor.executePage((BoundSql)args[5]);
        }
        return invocation.proceed();
    }
}

