package com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc;

import com.digiwin.dap.nest.kernel.core.util.reflect.JaReflectUtil;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.config.JdbcUrlConfig;
import lombok.SneakyThrows;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * jdbc url 处理器
 *
 * @author chenjian
 * @since 2024年03月31日 20:14:11
 */
public class DwJdbcUrlProcessor {

    private DwJdbcUrlProcessor() {
    }

    @SneakyThrows
    public static String getSimple(String ip, String port, String database) {
        return get(ip, port, database, new JdbcUrlConfig());
    }


    @SneakyThrows
    public static String get(String ip, String port, String database, JdbcUrlConfig jdbcUrlParam) {
        List<Field> allFields = JaReflectUtil.getAllFields(JdbcUrlConfig.class);
        List<String> paramList = new ArrayList<>();
        for (Field field : allFields) {
            field.setAccessible(true);
            paramList.add(field.getName() + "=" + field.get(jdbcUrlParam).toString());
        }
        String jdbcUrl = "jdbc:mysql://%s:%s/%s?" + String.join("&", paramList);
        return String.format(jdbcUrl, ip, port, database);
    }

    public static void main(String[] args) {
        System.out.println(DwJdbcUrlProcessor.getSimple("ip", "port", "database"));
    }
}
