package com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.interceptor;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.page.DwMybatisPage;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.page.DwMybatisPageProcessor;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;

import java.sql.Connection;

/**
 * 1.分页插件, 并行处理, 提高查询效率
 *
 * @author chenjian
 * @since 2020年06月20日 20:23:23
 */
@Intercepts({
        @Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})
        , @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})
        , @Signature(type = Executor.class, method = "update", args = {MappedStatement.class, Object.class})
})
@Component
public class JaMybatisInterceptor implements Interceptor {

    @Override
    @SuppressWarnings("all")
    public Object intercept(Invocation invocation) throws Throwable {
        if (null != DwMybatisPage.PageThreadLocal.get()) {// TODO 后续handler多了需要抽象出来判断
            Object[] args = invocation.getArgs();

            Object target = invocation.getTarget();

            Object parameter = null;

            // 只支持StatementType.PREPARED
            if (target instanceof StatementHandler) {
//                Object delegate = target instanceof RoutingStatementHandler ? target : SystemMetaObject.forObject(target).getValue("delegate");
                Object delegate = SystemMetaObject.forObject(target).getValue("delegate");

                BoundSql boundSql = (BoundSql) SystemMetaObject.forObject(delegate).getValue("boundSql");
                MappedStatement mappedStatement = (MappedStatement) SystemMetaObject.forObject(delegate).getValue("mappedStatement");
                if (SqlCommandType.SELECT == mappedStatement.getSqlCommandType()) {
                    parameter = boundSql.getParameterObject();
                    DwMybatisPageProcessor.executePage(boundSql);
                }
            } else {
                parameter = args[1];
                if (target instanceof Executor && args.length == 2) {
                    MappedStatement mappedStatement = (MappedStatement) args[0];
                    SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
                    if (SqlCommandType.INSERT == sqlCommandType || SqlCommandType.UPDATE == sqlCommandType) {
//                    ExecuteUpdateUtil.executeUpdate(parameter, sqlCommandType, mappedStatement.getId());
                    }
                } else {
                    DwMybatisPageProcessor.executePage((BoundSql) args[5]);
                }
            }
        }

        return invocation.proceed();
    }
}
