package com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.interceptor;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.page.DwMybatisPageProcessor;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.springframework.stereotype.Component;

import java.sql.Statement;

/**
 * 兼容mybatis-plus page
 *
 * @author chenjian
 * @since 2021年03月03日 18:20:48
 */
@Component
@Intercepts({@Signature(type = ResultSetHandler.class, method = "handleResultSets", args = {Statement.class})})
public class JaMybatisResultSetHandlerInterceptor implements Interceptor {

    public Object intercept(Invocation invocation) throws Throwable {
        if (DwMybatisPageProcessor.executePageCount()) {
            return DwMybatisPageProcessor.getPageCount(invocation);
        } else {
            return invocation.proceed();
        }
    }
}
