/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.DwDataSourceFactory;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.DwDataSourceRoute;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.meta.DwDataSourceAnnotation;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.transaction.DwTransactionProcessor;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.config.DwPropertyListener;
import com.digiwin.dap.nest.kernel.core.dapper.alarm.JaAlarm;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import javax.sql.DataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
public class DwConnectionAspect {
    private static long timeoutDbConn;
    private static final String keyTimeoutDbConn = "dw.dapper.common.timeout.db-conn";

    @Pointcut(value="execution(* javax.sql.DataSource.getConnection())")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        return this.getConnection(pjp);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object getConnection(ProceedingJoinPoint pjp) throws Throwable {
        DwDataSourceAnnotation route = (DwDataSourceAnnotation)DwDataSourceRoute.getRoute().get();
        if (null == route) {
            return pjp.proceed();
        }
        DataSource dataSource = null;
        Map<String, DataSource> dataSourcePool = DwDataSourceFactory.get();
        if (JaCollectionUtil.isNotEmpty(dataSourcePool)) {
            if (route.isSlaver() && (TransactionSynchronizationManager.isActualTransactionActive() || DwTransactionProcessor.isBeginSpringTx())) {
                String master = route.getMaster();
                if (!DwStringUtil.isNotEmpty((String)master)) {
                    DwLog.get().debug("datasource route slave by : master");
                    return pjp.proceed();
                }
                dataSource = dataSourcePool.get(master);
            } else {
                DwLog.get().debug("datasource route by : {}", (Object)route.getName());
                dataSource = dataSourcePool.get(route.getName());
            }
        }
        if (null == dataSource) {
            throw new RuntimeException("switch datasource error, datasource is null : " + route.getName());
        }
        DwLog.get().debug("datasource route by : {}", (Object)route.getName());
        return dataSource.getConnection();
    }

    private void alarm(long start, ProceedingJoinPoint pjp) {
        long end = System.currentTimeMillis() - start;
        JaAlarm.alarmAndLog((end > timeoutDbConn ? 1 : 0) != 0, () -> {
            Object target = pjp.getTarget();
            String poolName = "";
            if (target instanceof HikariDataSource) {
                poolName = ((HikariDataSource)target).getPoolName();
            }
            return String.format("javax.sql.DataSource.getConnection poolName:%s timeout: %s > %s", poolName, end, timeoutDbConn);
        }, () -> "javax.sql.DataSource.getConnection timeout");
    }

    static {
        DwPropertyListener.addAndRunCommonListener(() -> {
            timeoutDbConn = DwProperty.getLong((String)keyTimeoutDbConn, (Long)200L);
        });
    }
}

