package com.digiwin.dap.nest.infrastructure.middleware.rdb.dapper;

import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaNodeSpanResolver;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.util.datastructure.DwCollectionUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

@Component
@ConditionalOnClass(name = {"org.mybatis.spring.annotation.MapperScan", DwNodeSpanMybatisPlus.ProxyClassName})
public class DwNodeSpanMybatisPlus implements JaNodeSpanResolver {
    public static final String ProxyClassName = "com.baomidou.mybatisplus.core.override.MybatisMapperProxy";
    private static final String mybatisPlus = "com.baomidou";
    private static final NodeKind mybatisPlusNodeKind = new NodeKind("db")
            .buildReqArgsHandler(args -> {
                if (DwCollectionUtil.isEmpty(args)) {
                    return args;
                }
                ArrayList<Object> objects = new ArrayList<>(args.length);
                for (Object arg : args) {
                    if (null != arg && arg.getClass().getName().startsWith(mybatisPlus)) {
                        continue;
                    }
                    objects.add(arg);
                }
                return objects.toArray();
            });

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        if (invocation instanceof ReflectiveMethodInvocation) {
            Object proxy = ((ReflectiveMethodInvocation) invocation).getProxy();
            if (proxy.toString().startsWith(mybatisPlus)) {
                return get(mybatisPlusNodeKind);
            }
        }
        return null;
    }
}
