package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect.DwConnectionAspect;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect.DwDataSourceAspect;
import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.util.DwThrowableUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.DwCollectionUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;
import java.util.Map;

@Configuration
@ConditionalOnProperty(name = DwConfig.KeyPrefix + "datasource.enabled", havingValue = "true")
public class DwDataSourceConfiguration implements InitializingBean {
    @Bean
    @Primary
    @ConditionalOnProperty(name = DwConfig.KeyPrefix + "datasource.primary", havingValue = "true", matchIfMissing = true)
    public DataSource dataSource() {
        DwDataSourceFactory.create();
        Map<String, DataSource> dataSourceMap = DwDataSourceFactory.get();
        if (DwCollectionUtil.isEmpty(dataSourceMap)) {
            DwThrowableUtil.throwRunLog("dataSourceMap is empty");
        }
        DataSource dataSource = dataSourceMap.get("default");
        if (null == dataSource) {
            dataSource = dataSourceMap.entrySet().iterator().next().getValue();
        }
        return dataSource;
    }

    @Bean
    public DwDataSourceAspect dataSourceAspect() {
        return new DwDataSourceAspect();
    }

    @Bean
    public DwConnectionAspect connectionAspect() {
        return new DwConnectionAspect();
    }

    @Override
    public void afterPropertiesSet() {
        if (null == DwDataSourceFactory.get()) {
            DwDataSourceFactory.create();
        }
    }

}
