package com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.generator;

import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.internal.util.StringUtility;

import java.util.List;

/**
 * 移除 selectKey 标签
 * 添加 useGeneratedKeys keyProperty 属性
 */
public class JaUseGeneratedKeysPlugin extends PluginAdapter {

    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean sqlMapDocumentGenerated(Document document,
                                           IntrospectedTable introspectedTable) {
        XmlElement root = document.getRootElement();
        for (int i = 0; i < root.getElements().size(); i++) {
            XmlElement element = (XmlElement) root.getElements().get(i);
            if ("insert".equalsIgnoreCase(element.getName())) {
                processGeneratedKey(element, introspectedTable);
            }
        }
        return true;
    }

    private void processGeneratedKey(XmlElement element, IntrospectedTable introspectedTable) {
        GeneratedKey gk = introspectedTable.getGeneratedKey();
        if (gk != null) {
            if (introspectedTable.hasPrimaryKeyColumns()) {
                if ("pre".equals(gk.getRuntimeSqlStatement())) {
                    return;
                }
                removeSelectKey(element);
                element.addAttribute(new Attribute("useGeneratedKeys", "true"));
                element.addAttribute(new Attribute("keyProperty", DwStringUtil.underscoreToCamelCase(gk.getColumn())));
                element.addAttribute(new Attribute("keyColumn", gk.getColumn()));
            }
        }
    }

    private void removeSelectKey(XmlElement element) {
        for (int i = 0; i < element.getElements().size(); i++) {
            if (element.getElements().get(i) instanceof XmlElement) {
                XmlElement xmlElement = (XmlElement) element.getElements().get(i);
                if (StringUtility.stringHasValue(xmlElement.getName())
                        && xmlElement.getName().equals("selectKey")) {
                    element.getElements().remove(i);
                    break;
                }
            }
        }
    }
}
