/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.DwDataSourceFactory;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect.DwConnectionAspect;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.aspect.DwDataSourceAspect;
import com.digiwin.dap.nest.kernel.core.util.DwThrowableUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.DwCollectionUtil;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(name={"dw.datasource.enabled"}, havingValue="true")
public class DwDataSourceConfiguration
implements InitializingBean {
    @Bean
    @Primary
    @ConditionalOnProperty(name={"dw.datasource.primary"}, havingValue="true", matchIfMissing=true)
    public DataSource dataSource() {
        DataSource dataSource;
        DwDataSourceFactory.create();
        Map<String, DataSource> dataSourceMap = DwDataSourceFactory.get();
        if (DwCollectionUtil.isEmpty(dataSourceMap)) {
            DwThrowableUtil.throwRunLog((String)"dataSourceMap is empty", (Object[])new Object[0]);
        }
        if (null == (dataSource = dataSourceMap.get("default"))) {
            dataSource = dataSourceMap.entrySet().iterator().next().getValue();
        }
        return dataSource;
    }

    @Bean
    public DwDataSourceAspect dataSourceAspect() {
        return new DwDataSourceAspect();
    }

    @Bean
    public DwConnectionAspect connectionAspect() {
        return new DwConnectionAspect();
    }

    public void afterPropertiesSet() {
        if (null == DwDataSourceFactory.get()) {
            DwDataSourceFactory.create();
        }
    }
}

