package com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.hikari;

import com.digiwin.dap.nest.kernel.meta.function.JaFunctionP;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.DwDataSourceFactory;
import com.digiwin.dap.nest.infrastructure.middleware.rdb.datasource.config.DwDataSourceConfig;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringBeanUtil;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import lombok.SneakyThrows;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DwHikariDataSourceProcessor {

    @SneakyThrows
    public static HikariDataSource create(String name, DwDataSourceConfig dataSourceConfig) {
        return create(name, dataSourceConfig, null);
    }

    @SneakyThrows
    public static HikariDataSource create(String name, DwDataSourceConfig dataSourceConfig, JaFunctionP<HikariConfig> configWrap) {
        HikariConfig config = new HikariConfig();
        config.setPoolName("HikariPool-" + name);
        if (DwStringUtil.isNotEmpty(dataSourceConfig.getDriverClassName())) {
            config.setDriverClassName(dataSourceConfig.getDriverClassName());
        }
        config.setUsername(dataSourceConfig.getUsername());
        config.setPassword(dataSourceConfig.getPassword());
        config.setMaxLifetime(dataSourceConfig.getMaxLifetime());
        config.setIdleTimeout(dataSourceConfig.getIdleTimeout());
        config.setMinimumIdle(dataSourceConfig.getMinIdle());
        config.setMaximumPoolSize(dataSourceConfig.getMaxActive());
        config.setConnectionTimeout(dataSourceConfig.getConnectionTimeout());
        // TODO 监控没生效
        config.setRegisterMbeans(dataSourceConfig.getHikariPC().isRegisterMbeans());
        if (dataSourceConfig.getHikariPC().isRegisterMbeans()) {
            MeterRegistry meterRegistry = DwSpringBeanUtil.getBean(MeterRegistry.class);
            if (null != meterRegistry) {
                config.setMetricsTrackerFactory(new MicrometerMetricsTrackerFactory(meterRegistry));
            }
        }
        config.setJdbcUrl(DwDataSourceFactory.getJdbcUrl(dataSourceConfig));
        DwDataSourceFactory.getJdbcProperty(dataSourceConfig).forEach(config::addDataSourceProperty);

        if (null != configWrap) {
            configWrap.apply(config);
        }
        return new HikariDataSource(config);
    }

    public static void main(String[] args) {
        DwDataSourceConfig dataSourceConfig = new DwDataSourceConfig();
        dataSourceConfig.setIp("gcss-gcsm-mysql-bhw-osit.mysql.oppo.test");
        dataSourceConfig.setPort("33066");
//        dataSourceConfig.setJdbcUrl("jdbc:mysql://gcss-gcsm-mysql-bhw-osit.mysql.oppo.test:33066/gcsm_basic_function?useSSL=false&characterEncoding=UTF-8&rewriteBatchedStatements=true&allowMultiQueries=true&connectionTimeZone=UTC&forceConnectionTimeZoneToSession=true");
        dataSourceConfig.setUsername("gcsm_osit");
        dataSourceConfig.setPassword("Op_tQMTc8J2l8WDp7TTwYTBNFLcaT3q6");
        dataSourceConfig.setDatabase("gcsm_basic_function");
        HikariDataSource dataSource = create("gcsm_basic_function", dataSourceConfig);
        String sql = "select 1";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();) {
            while (rs.next()) {
                System.out.println(rs.getObject(1));
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }
        dataSource.close();
    }
}
