package com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc;

import com.digiwin.dap.nest.infrastructure.middleware.rdb.jdbc.meta.DwJdbcDriverConstants;
import lombok.SneakyThrows;

import java.sql.Connection;
import java.sql.DriverManager;

/**
 * jdbc connection 处理器
 *
 * @author chenjian
 * @since 2024年03月31日 20:13:22
 */
public class DwJdbcConnectionProcessor {

    /**
     * 获取一个简易的connection
     */
    public static Connection getSimple(String ip, String port, String database, String username, String password) {
        String url = DwJdbcUrlProcessor.getSimple(ip, port, database);
        return get(url, username, password);
    }

    @SneakyThrows
    public static Connection get(String url, String username, String password) {
        Class.forName(DwJdbcDriverConstants.Mysql);
        return DriverManager.getConnection(url, username, password);
    }

    @SneakyThrows
    public static void close(Connection connection) {
        if (null != connection) {
            connection.close();
        }
    }


}
