package com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.generator;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;

import java.util.Iterator;
import java.util.List;

public class JaBatchInsertPlugin extends PluginAdapter {
    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        createBatchInsertSql(document, introspectedTable);
        return true;
    }

    @Override
    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        Method m = generateBatchInsertMethod(recordType);
        interfaze.addMethod(m);
        interfaze.addImportedType(recordType);
        interfaze.addImportedType(new FullyQualifiedJavaType("java.util.List"));
        return true;
    }

    private Method generateBatchInsertMethod(FullyQualifiedJavaType recordType) {
        Method method = new Method("insertBatch");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setAbstract(true);

        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType("java.lang.Integer");
        method.setReturnType(returnType);

        FullyQualifiedJavaType parameterType = FullyQualifiedJavaType.getNewListInstance();
        parameterType.addTypeArgument(recordType);

        Parameter parameter = new Parameter(parameterType, "records");
        method.addParameter(parameter);
        return method;
    }

    private void createBatchInsertSql(Document document, IntrospectedTable introspectedTable) {
        List<IntrospectedColumn> columns = introspectedTable.getAllColumns();
        // 创建BatchInsert XML节点
        XmlElement insertBatchElement = new XmlElement("insert");
        insertBatchElement.addAttribute(new Attribute("id", "insertBatch"));
        context.getCommentGenerator().addComment(insertBatchElement);

        StringBuilder insertClause = new StringBuilder();
        insertClause.append("insert into ").append(introspectedTable.getFullyQualifiedTableNameAtRuntime())
                .append(" (");

        Iterator<IntrospectedColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            IntrospectedColumn introspectedColumn = iter.next();
            if (introspectedColumn.isIdentity()) {
                // 如果是自增列，跳过
                continue;
            }
            insertClause.append("\n")
                    .append("      ")
                    .append(MyBatis3FormattingUtilities.getEscapedColumnName(introspectedColumn));
            if (iter.hasNext()) {
                insertClause.append(", ");
            }
        }
        insertClause.append(')');
        insertBatchElement.addElement(new TextElement(insertClause.toString()));
        insertBatchElement.addElement(new TextElement("values"));

        XmlElement foreach = new XmlElement("foreach");
        foreach.addAttribute(new Attribute("collection", "list"));
        foreach.addAttribute(new Attribute("item", "item"));
        foreach.addAttribute(new Attribute("separator", ","));

        StringBuilder valuesClause = new StringBuilder();
        valuesClause.append(" (");
        iter = columns.iterator();
        while (iter.hasNext()) {
            IntrospectedColumn introspectedColumn = iter.next();
            if (introspectedColumn.isIdentity()) {
                continue;
            }
            valuesClause.append("\n")
                    .append("      ")
                    .append("#{item.").append(introspectedColumn.getJavaProperty()).append(",jdbcType=")
                    .append(introspectedColumn.getJdbcTypeName()).append("}");
            if (iter.hasNext()) {
                valuesClause.append(", ");
            }
        }
        valuesClause.append(")");
        foreach.addElement(new TextElement(valuesClause.toString()));

        insertBatchElement.addElement(foreach);
        // 在document根节点增加子节点
        document.getRootElement().addElement(insertBatchElement);
    }
}
