package com.digiwin.dap.nest.infrastructure.middleware.rdb.mybatis.page;

import com.digiwin.dap.nest.kernel.core.util.concurrent.DwThreadPool;
import com.digiwin.dap.nest.kernel.meta.JaReturn2;
import com.digiwin.dap.nest.kernel.meta.dto.DwPageReqDTO;
import com.digiwin.dap.nest.kernel.meta.function.JaFunctionR;
import lombok.SneakyThrows;

import java.util.List;
import java.util.concurrent.Future;

public class DwMybatisPage {

    private DwMybatisPage() {
    }

    public static final ThreadLocal<DwMybatisPageContext> PageThreadLocal = new ThreadLocal<>();

    public static <T> JaReturn2<Long, List<T>> page(DwPageReqDTO pageReqDTO, JaFunctionR<List<T>> functionR) {
        return page(pageReqDTO.getPageSize(), pageReqDTO.getPageIndex(), functionR);
    }

    @SneakyThrows
    public static <T> JaReturn2<Long, List<T>> page(Integer pageSize, Integer pageIndex, JaFunctionR<List<T>> functionR) {
        Future<List<T>> pageFuture = DwThreadPool.submit(() -> {
            PageThreadLocal.set(DwMybatisPageContext.builder().isCount(false).pageSize(pageSize).pageIndex(pageIndex).build());
            try {
                return functionR.apply();
            } finally {
                PageThreadLocal.set(null);
                PageThreadLocal.remove();
            }

        });
        Future<Long> countFuture = DwThreadPool.submit(() -> {
            PageThreadLocal.set(DwMybatisPageContext.builder().isCount(true).pageSize(pageSize).pageIndex(pageIndex).build());
            try {
                functionR.apply();
                return PageThreadLocal.get().getCount();
            } finally {
                PageThreadLocal.set(null);
                PageThreadLocal.remove();
            }

        });

        return new JaReturn2<>(countFuture.get(), pageFuture.get());
    }

}