/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import com.jugg.agile.framework.core.util.io.serialize.json.adapter.jackson.migration.JacksonAutoType;
import com.jugg.agile.middleware.redis.JaRedis;
import java.lang.reflect.Type;
import java.util.List;

public class JaRedisNamespace {
    public static Boolean setString(String key, String value, Long ... seconds) {
        return JaRedis.setString(JaRedisNamespace.wrapKey(key), value, seconds);
    }

    public static Boolean setNx(String key, String value, Long ... seconds) {
        return JaRedis.setNx(JaRedisNamespace.wrapKey(key), value, seconds);
    }

    public static <T> Boolean setT(String key, T value, Long ... seconds) {
        return JaRedis.setT(JaRedisNamespace.wrapKey(key), JacksonAutoType.Instance.toString(value), seconds);
    }

    public static <T> Boolean setJson(String key, T value, Long ... seconds) {
        return JaRedis.setJson(JaRedisNamespace.wrapKey(key), JaJson.toString(value), seconds);
    }

    public static String getString(String key) {
        return JaRedis.getString(JaRedisNamespace.wrapKey(key));
    }

    public static <T> T getByJson(String key, Type type) {
        return JaRedis.getByJson(JaRedisNamespace.wrapKey(key), type);
    }

    public static <T> T getT(String key) {
        return JaRedis.getT(JaRedisNamespace.wrapKey(key));
    }

    public static Long del(String key) {
        return JaRedis.del(JaRedisNamespace.wrapKey(key));
    }

    public static Boolean exists(String key) {
        return JaRedis.exists(JaRedisNamespace.wrapKey(key));
    }

    public static Long expire(String key, Long seconds) {
        return JaRedis.expire(JaRedisNamespace.wrapKey(key), seconds);
    }

    public static Long incr(String key, Long ... increment) {
        return JaRedis.incr(JaRedisNamespace.wrapKey(key), increment);
    }

    public static Long decr(String key, Long ... increment) {
        return JaRedis.decr(JaRedisNamespace.wrapKey(key), increment);
    }

    public static Object eval(String script, List<String> keys, List<String> args) {
        return JaRedis.eval(script, keys, args);
    }

    public static Long lpush(String key, String ... args) {
        return JaRedis.lpush(JaRedisNamespace.wrapKey(key), args);
    }

    public static Long rpush(String key, String ... args) {
        return JaRedis.rpush(JaRedisNamespace.wrapKey(key), args);
    }

    public static List<String> lrange(String key, long start, long end) {
        return JaRedis.lrange(JaRedisNamespace.wrapKey(key), start, end);
    }

    public static String lindex(String key, long index) {
        return JaRedis.lindex(JaRedisNamespace.wrapKey(key), index);
    }

    public static Long lrem(String key, long count, String value) {
        return JaRedis.lrem(JaRedisNamespace.wrapKey(key), count, value);
    }

    public static String wrapKey(String key) {
        return JaEnvProperty.getApplicationName() + ":" + key;
    }
}

