/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis.adapter.redisson.pool;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaSystemProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;

public class RedissonClusterPool {
    private static volatile RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (null != redissonClient) return;
        Class<RedissonClusterPool> clazz = RedissonClusterPool.class;
        synchronized (RedissonClusterPool.class) {
            if (null != redissonClient) return;
            Config config = RedissonClusterPool.readConfig();
            try {
                redissonClient = Redisson.create((Config)RedissonClusterPool.readConfig());
            }
            catch (Throwable e) {
                JaLog.get().error("redisson init error", e);
                config.setTransportMode(TransportMode.NIO);
                redissonClient = Redisson.create((Config)config);
            }
            return;
        }
    }

    public static RedissonClient get() {
        return redissonClient;
    }

    private static Config readConfig() {
        Config config = new Config();
        String epoll = RedissonClusterPool.get("epoll");
        if (!JaSystemProperty.isWindows()) {
            config.setTransportMode(TransportMode.EPOLL);
        } else {
            config.setTransportMode(TransportMode.NIO);
        }
        String lockWatchdogTimeout = RedissonClusterPool.get("lockWatchdogTimeout");
        if (JaStringUtil.isNotEmpty((String)lockWatchdogTimeout)) {
            config.setLockWatchdogTimeout(Long.parseLong(lockWatchdogTimeout));
        }
        config.setKeepPubSubOrder(false);
        String cluster = JaProperty.get((String)"redis.cluster");
        assert (cluster != null);
        String[] clusterArray = cluster.split(",");
        for (int i = 0; i < clusterArray.length; ++i) {
            clusterArray[i] = "redis://" + clusterArray[i];
        }
        String scanInterval = RedissonClusterPool.get("scanInterval");
        String subscriptionConnectionMinimumIdleSize = RedissonClusterPool.get("subscriptionConnectionMinimumIdleSize");
        String subscriptionConnectionPoolSize = RedissonClusterPool.get("subscriptionConnectionPoolSize");
        String subscriptionsPerConnection = RedissonClusterPool.get("subscriptionsPerConnection");
        String slaveConnectionMinimumIdleSize = RedissonClusterPool.get("slaveConnectionMinimumIdleSize");
        String slaveConnectionPoolSize = RedissonClusterPool.get("slaveConnectionPoolSize");
        String masterConnectionMinimumIdleSize = RedissonClusterPool.get("masterConnectionMinimumIdleSize");
        String masterConnectionPoolSize = RedissonClusterPool.get("masterConnectionPoolSize");
        String idleConnectionTimeout = RedissonClusterPool.get("idleConnectionTimeout");
        String connectTimeout = RedissonClusterPool.get("connectTimeout");
        String timeout = RedissonClusterPool.get("timeout");
        String retryAttempts = RedissonClusterPool.get("retryAttempts");
        String retryInterval = RedissonClusterPool.get("retryInterval");
        String reconnectionTimeout = RedissonClusterPool.get("reconnectionTimeout");
        String failedAttempts = RedissonClusterPool.get("failedAttempts");
        config.setCodec((Codec)JsonJacksonCodec.INSTANCE);
        ((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().setPassword(JaProperty.get((String)"redis.password"))).setScanInterval(JaStringUtil.isEmpty((String)scanInterval) ? 1800000 : Integer.parseInt(scanInterval)).setSubscriptionConnectionMinimumIdleSize(JaStringUtil.isEmpty((String)subscriptionConnectionMinimumIdleSize) ? 1 : Integer.parseInt(subscriptionConnectionMinimumIdleSize))).setSubscriptionConnectionPoolSize(JaStringUtil.isEmpty((String)subscriptionConnectionPoolSize) ? 20 : Integer.parseInt(subscriptionConnectionPoolSize))).setSubscriptionsPerConnection(JaStringUtil.isEmpty((String)subscriptionsPerConnection) ? 5 : Integer.parseInt(subscriptionsPerConnection))).setSlaveConnectionMinimumIdleSize(JaStringUtil.isEmpty((String)slaveConnectionMinimumIdleSize) ? 12 : Integer.parseInt(slaveConnectionMinimumIdleSize))).setSlaveConnectionPoolSize(JaStringUtil.isEmpty((String)slaveConnectionPoolSize) ? 64 : Integer.parseInt(slaveConnectionPoolSize))).setMasterConnectionMinimumIdleSize(JaStringUtil.isEmpty((String)masterConnectionMinimumIdleSize) ? 12 : Integer.parseInt(masterConnectionMinimumIdleSize))).setMasterConnectionPoolSize(JaStringUtil.isEmpty((String)masterConnectionPoolSize) ? 64 : Integer.parseInt(masterConnectionPoolSize))).setIdleConnectionTimeout(JaStringUtil.isEmpty((String)idleConnectionTimeout) ? 10000 : Integer.parseInt(idleConnectionTimeout))).setConnectTimeout(JaStringUtil.isEmpty((String)connectTimeout) ? 4000 : Integer.parseInt(connectTimeout))).setTimeout(JaStringUtil.isEmpty((String)timeout) ? 2000 : Integer.parseInt(timeout))).setRetryAttempts(JaStringUtil.isEmpty((String)retryAttempts) ? 0 : Integer.parseInt(retryAttempts))).setRetryInterval(JaStringUtil.isEmpty((String)retryInterval) ? 1000 : Integer.parseInt(retryInterval))).addNodeAddress(clusterArray);
        return config;
    }

    private static String get(String name) {
        return JaProperty.get((String)("redis.redisson" + name));
    }
}

