package com.jugg.agile.middleware.redis.adapter.redisson;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.meta.dto.JaResultDTO;
import com.jugg.agile.middleware.redis.adapter.redisson.pool.RedissonClusterPool;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.redisson.api.RBucket;
import org.redisson.codec.JsonJacksonCodec;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * 不会自动拼接应用名, 会重复, 用来共有
 *
 * @author chenjian
 * @since 2020年09月03日 10:38:17
 */
public class JaRedissonAdapter {
    public static void main(String[] args) throws IOException, InterruptedException {
        JaResultDTO<List<String>> listJaResultDTO = new JaResultDTO<>();
        listJaResultDTO.setData(Arrays.asList("demo", "ddd"));
        listJaResultDTO.setCode("code");
        listJaResultDTO.setCodeMsg("msg");

        JSON.toJSONString(Arrays.asList("demo", "ddd"));
        JSON.toJSONString(listJaResultDTO);

        ObjectMapper mapObjectMapper = new JsonJacksonCodec().getObjectMapper();
        mapObjectMapper.writeValueAsString(listJaResultDTO);
        System.out.println(mapObjectMapper.writeValueAsString(listJaResultDTO));

        // 172.16.2.230
        // 6379
        // 123456

        JaProperty.getPropertyMap().put("redis.cluster", "10.3.205.57:9736,10.3.228.230:9736,10.3.194.84:9736,10.3.232.219:9736");
        JaProperty.getPropertyMap().put("redis.password", "YOTUVDuTMxNpneNA");
        RedissonClusterPool.init();


        for (int i = 0; i < 20; i++) {
            Thread thread = new Thread("dd" + i) {
                @Override
                public void run() {
                    long s = System.currentTimeMillis();
                    RBucket<JaResultDTO<List<String>>> bucket = RedissonClusterPool.get().getBucket("demo");
                    bucket.set(listJaResultDTO);
                    JaLog.info(System.currentTimeMillis() - s + "");

                    s = System.currentTimeMillis();
                    JaResultDTO<List<String>> listJaResultDTO1 = bucket.get();
                    JaLog.info(System.currentTimeMillis() - s + "");
//
//                    s = System.currentTimeMillis();
//                    bucket.set(listJaResultDTO);
//                    JaLog.info(System.currentTimeMillis() - s + "");
//
//                    s = System.currentTimeMillis();
//                    JaResultDTO<List<String>> listJaResultDTO11 = bucket.get();
//                    JaLog.info(System.currentTimeMillis() - s + "");
                }
            };
            thread.start();
        }


        Thread.sleep(10000);
        System.out.println();
    }
}
